package cn.net.wanmo.common.result;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.JacksonUtil;
import com.alibaba.fastjson.JSON;

import java.io.Serializable;

public abstract class DefaultResult<Code, Data> implements Serializable {
    // ------------------------- success start ----------------------------------
    public DefaultResult success(String msg, Data data) {
        setCode(defaultSuccessCode());
        setMsg(msg);
        setData(data);
        return this;
    }

    public DefaultResult success(String msg) {
        return success(msg, null);
    }

    public DefaultResult success(Data data) {
        return success(defaultSuccessMsg(), data);
    }

    public DefaultResult success() {
        return success(defaultSuccessMsg(), null);
    }
    // ------------------------- success end ----------------------------------


    // ------------------------- error start ----------------------------------
    public DefaultResult error(String msg, Data data) {
        setCode(defaultErrorCode());
        setMsg(msg);
        setData(data);
        return this;
    }

    public DefaultResult error(String msg) {
        return error(msg, null);
    }

    public DefaultResult error() {
        return error(defaultErrorMsg(), null);
    }

    // ------------------------- error end ----------------------------------


    // ------------------------- fail start ----------------------------------

    public DefaultResult fail(Code code, String msg, Data data) {
        setCode(code);
        setMsg(msg);
        setData(data);
        return this;
    }

    public DefaultResult fail(Code code, String msg) {
        return fail(code, msg, null);
    }

    // ------------------------- fail end ----------------------------------

    public String tip() {
        return String.format("内容：【%s】，代码：【%s】，数据：【%s】，是否成功：【%b】", getMsg(), getCode(), JSON.toJSON(getData()), isSuccess());
    }

    public String toJSONString() {
        return JSON.toJSONString(this);
    }



    // ------------------------- field start ----------------------------------
    /** 错误代码 */
    protected Code code;
    /** 错误提示 */
    protected String msg;
    /** 详细描述 */
    protected String desc;
    /** 数据 */
    protected Data data;
    /** 起始时间 */
    protected Long startTime;
    /** 耗时 */
    protected Long consumeTime;

    public DefaultResult() {
        this.startTime = DateUtil.nowLong();
    }

    public DefaultResult(Code code, String msg, Data data) {
        this();

        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Code getCode() {
        return code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getConsumeTime() {
        return consumeTime;
    }

    public void setConsumeTime(Long consumeTime) {
        this.consumeTime = consumeTime;
    }

    /**
     * 内置的耗时计算（单位：毫秒）
     * @return 耗时
     */
    public Long innerConsumeTime() {
        return DateUtil.nowLong() - this.startTime;
    }

    public abstract Code defaultSuccessCode();

    public abstract String defaultSuccessMsg();

    public abstract Code defaultErrorCode();

    public abstract String defaultErrorMsg();

    public abstract boolean isSuccess();
// ------------------------- field end ----------------------------------
}
