package cn.net.wanmo.common.result;

import cn.net.wanmo.common.util.ObjectUtil;
import cn.net.wanmo.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

/**
 * 接口响应数据结果
 *
 * @param <T> 数据类型
 */
public class WanMoResult<T> extends JSONObject implements Serializable {
    protected static final long serialVersionUID = 1L;
    public static final String CODE_TAG = "code";
    public static final String MSG_TAG = "msg";
    public static final String DESC_TAG = "desc";
    public static final String DATA_TAG = "data";
    public static final String CONSUME_TIME_TAG = "consumeTime";

    public static String DEFAULT_SUCCESS_CODE = "success";
    public static String DEFAULT_SUCCESS_MSG = "操作成功";
    public static String DEFAULT_ERROR_CODE = "error";
    public static String DEFAULT_ERROR_MSG = "操作失败";

    public WanMoResult() {
    }

    public WanMoResult(String code, String msg) {
        super.put(CODE_TAG, code);
        super.put(MSG_TAG, msg);
    }

    public WanMoResult(String code, String msg, T data) {
        this(code, msg);
        super.put(DATA_TAG, data);
    }

    public static WanMoResult success() {
        return success(DEFAULT_SUCCESS_MSG);
    }

    public static WanMoResult success(String msg) {
        return new WanMoResult(DEFAULT_SUCCESS_CODE, msg, null);
    }

    public static <T> WanMoResult success(T data) {
        return success(DEFAULT_SUCCESS_MSG, data);
    }

    public static <T> WanMoResult success(String msg, T data) {
        return new WanMoResult(DEFAULT_SUCCESS_CODE, msg, data);
    }

    public static WanMoResult error() {
        return error(DEFAULT_ERROR_MSG);
    }

    public static WanMoResult error(String msg) {
        return new WanMoResult(DEFAULT_ERROR_CODE, msg, null);
    }

    public static <T> WanMoResult error(String msg, T data) {
        return new WanMoResult(DEFAULT_ERROR_CODE, msg, data);
    }

    public static WanMoResult fail(String code, String msg) {
        return new WanMoResult(code, msg, null);
    }

    public boolean isSuccess() {
        return StringUtil.equals(DEFAULT_SUCCESS_CODE, getCode());
    }

    @Override
    public WanMoResult put(String key, Object value) {
        super.put(key, value);
        return this;
    }

    public WanMoResult setCode(String code) {
        return this.put(CODE_TAG, code);
    }

    public String getCode() {
        return getString(CODE_TAG);
    }

    public WanMoResult setMsg(String msg) {
        return this.put(MSG_TAG, msg);
    }

    public String getMsg() {
        return getString(MSG_TAG);
    }

    public WanMoResult setDesc(String desc) {
        return this.put(DESC_TAG, desc);
    }

    public String getDesc() {
        return getString(DESC_TAG);
    }

    public WanMoResult setConsumeTime(Integer consumeTime) {
        return this.put(CONSUME_TIME_TAG, consumeTime);
    }

    public Integer getConsumeTime() {
        return getInteger(CONSUME_TIME_TAG);
    }

    public WanMoResult setData(T data) {
        return this.put(DATA_TAG, data);
    }

    public T getData() {
        return ObjectUtil.cast(get(DATA_TAG));
    }

    public String getTip() {
        put("success", isSuccess());
        return JSON.toJSONString(this, true);
    }
}
