/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.codec;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringEscapeUtils;

public class CodecUtil {
    public static final String UTF8_NAME = CharsetUtil.UTF8_NAME;
    public static final Charset UTF8 = CharsetUtil.UTF8;

    public static String toHex(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                s = "0" + s;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) {
        try {
            if (input == null) {
                return null;
            }
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw Exceptions.unchecked((Exception)((Object)e));
        }
    }

    public static String encodeBase64(byte[] bytes) {
        return CodecUtil.encodeBase64(bytes, UTF8);
    }

    public static String encodeBase64(byte[] bytes, Charset charset) {
        byte[] encodeBase64 = Base64.encodeBase64((byte[])bytes);
        return StringUtil.toEncodedString((byte[])encodeBase64, (Charset)charset);
    }

    public static String encodeBase64(String input) {
        return CodecUtil.encodeBase64(input, UTF8);
    }

    public static String encodeBase64(String input, Charset charset) {
        if (input == null) {
            return null;
        }
        byte[] bytes = input.getBytes(charset);
        return CodecUtil.encodeBase64(bytes, charset);
    }

    public static byte[] decodeBase64(String input) {
        return CodecUtil.decodeBase64(input, UTF8);
    }

    public static byte[] decodeBase64(String input, Charset charset) {
        if (input == null) {
            return null;
        }
        byte[] bytes = input.getBytes(charset);
        return Base64.decodeBase64((byte[])bytes);
    }

    public static String decodeBase64String(String input) {
        return CodecUtil.decodeBase64String(input, UTF8);
    }

    public static String decodeBase64String(String input, Charset charset) {
        byte[] decodeBase64 = CodecUtil.decodeBase64(input, charset);
        return StringUtil.toEncodedString((byte[])decodeBase64, (Charset)charset);
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static String unescapeHtml(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml4((String)htmlEscaped);
    }

    public static String escapeXml(String xml) {
        return StringEscapeUtils.escapeXml10((String)xml);
    }

    public static String unescapeXml(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }

    public static String urlEncode(String part) {
        return CodecUtil.urlEncode(part, UTF8_NAME);
    }

    public static String urlEncode(String part, String charsetName) {
        try {
            return URLEncoder.encode(part, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String urlDecode(String part) {
        return CodecUtil.urlDecode(part, UTF8_NAME);
    }

    public static String urlDecode(String part, String charsetName) {
        try {
            return URLDecoder.decode(part, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.unchecked(e);
        }
    }
}

