/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class DateTimeUtil {
    public static Date nowDate() {
        return DateTimeUtil.toDate(DateTimeUtil.nowLocalDateTime());
    }

    public static LocalDate nowLocalDate() {
        return LocalDate.now(DateTimeUtil.getZoneId());
    }

    public static LocalTime nowLocalTime() {
        return LocalTime.now(DateTimeUtil.getZoneId());
    }

    public static LocalDateTime nowLocalDateTime() {
        return LocalDateTime.now(DateTimeUtil.getZoneId());
    }

    public static String nowDay() {
        return DateTimeUtil.formatDay(DateTimeUtil.nowLocalDate());
    }

    public static String nowTime() {
        return DateTimeUtil.formatTime(DateTimeUtil.nowLocalTime());
    }

    public static String nowDayTime() {
        return DateTimeUtil.formatDayTime(DateTimeUtil.nowLocalDateTime());
    }

    public static String formatTime(LocalTime localTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.CHINA);
        return localTime.format(formatter);
    }

    public static String formatTime(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    public static String formatTime(Date date) {
        return DateTimeUtil.formatTime(DateTimeUtil.toLocalTime(date));
    }

    public static String formatDay(LocalDate localDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.CHINA);
        return localDate.format(formatter);
    }

    public static String formatDay(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    public static String formatDay(Date date) {
        return DateTimeUtil.formatDay(DateTimeUtil.toLocalDate(date));
    }

    public static String formatDayTime(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    public static String formatDayTime(Date date) {
        return DateTimeUtil.formatDayTime(DateTimeUtil.toLocalDateTime(date));
    }

    public static LocalDate parseLocalDate(String s) {
        return LocalDate.parse(s);
    }

    public static LocalDate parseLocalDate(String s, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return LocalDate.parse(s, formatter);
    }

    public static LocalTime parseLocalTime(String s) {
        return LocalTime.parse(s);
    }

    public static LocalTime parseLocalTime(String s, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return LocalTime.parse(s, formatter);
    }

    public static LocalDateTime parseLocalDateTime(String s) {
        return LocalDateTime.parse(s);
    }

    public static LocalDateTime parseLocalDateTime(String s, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return LocalDateTime.parse(s, formatter);
    }

    public static Date parseDate(String s) {
        LocalDateTime localDateTime = DateTimeUtil.parseLocalDateTime(s);
        return DateTimeUtil.toDate(localDateTime);
    }

    public static Date parseDate(String s, String pattern) {
        LocalDateTime localDateTime = DateTimeUtil.parseLocalDateTime(s, pattern);
        return DateTimeUtil.toDate(localDateTime);
    }

    public static Date toDate(LocalDate localDate) {
        return DateTimeUtil.toDate(localDate, null);
    }

    public static Date toDate(LocalDate localDate, LocalTime localTime) {
        LocalDateTime localDateTime = null;
        localDateTime = localTime == null ? localDate.atStartOfDay() : localDate.atTime(localTime);
        return DateTimeUtil.toDate(localDateTime);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(DateTimeUtil.getZoneId()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        LocalDateTime localDateTime = DateTimeUtil.toLocalDateTime(date);
        return localDateTime.toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        LocalDateTime localDateTime = DateTimeUtil.toLocalDateTime(date);
        return localDateTime.toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), DateTimeUtil.getZoneId());
    }

    public static LocalDateTime minusDays(long days) {
        return DateTimeUtil.nowLocalDateTime().minusDays(days);
    }

    public static LocalDateTime minusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.minusDays(days);
    }

    public static LocalDateTime plusDays(long days) {
        return DateTimeUtil.nowLocalDateTime().plusDays(days);
    }

    public static LocalDateTime plusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.plusDays(days);
    }

    public static boolean isEqual(LocalDate localDate1, LocalDate localDate2) {
        return localDate1.isEqual(localDate2);
    }

    public static boolean isEqual(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        return localDateTime1.isEqual(localDateTime2);
    }

    public static ZoneId getZoneId() {
        return DateTimeUtil.getZoneId_02();
    }

    private static ZoneId getZoneId_01() {
        return ZoneId.of("Asia/Shanghai");
    }

    private static ZoneId getZoneId_02() {
        return ZoneId.of(ZoneId.SHORT_IDS.get("CTT"));
    }

    public static void printZoneIds() {
        Set<String> zoneIds = ZoneId.getAvailableZoneIds();
        zoneIds.stream().iterator().forEachRemaining(s -> System.out.println((String)s));
    }
}

