package cn.net.wanmo.common.result;

import cn.net.wanmo.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;

public class InterfaceResult<Data> extends DefaultResult<String, Data> {
    Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void setCode(String s) {
        super.setCode(s);
    }

    @Override
    public String getCode() {
        return super.getCode();
    }

    /**
     * 获取整数类型的接口响应编码
     *
     * @return 接口响应编码
     */
    public Integer codeInt() {
        try {
            return Integer.valueOf(code);
        } catch (Exception e) {
            logger.error("接口响应编码【" + code + "】转 int 类型异常", e);
            return null;
        }
    }

    @Override
    public String defaultSuccessCode() {
        return "0";
    }

    @Override
    public String defaultSuccessMsg() {
        return "操作成功";
    }

    @Override
    public String defaultErrorCode() {
        return "500000";
    }

    @Override
    public String defaultErrorMsg() {
        return "操作失败";
    }

    @Override
    public boolean isSuccess() {
        return StringUtil.equals(defaultSuccessCode(), getCode());
    }
}
