package cn.net.wanmo.common.constant;

import java.net.HttpURLConnection;

/**
 * Http 返回状态码
 */
public class HttpStatus {

    /**
     * HTTP Status-Code 200: 操作成功
     */
    public static final int SUCCESS = HttpURLConnection.HTTP_OK;

    /**
     * HTTP Status-Code 201: 对象创建成功
     */
    public static final int CREATED = HttpURLConnection.HTTP_CREATED;

    /**
     * HTTP Status-Code 202: 请求已经被接受
     */
    public static final int ACCEPTED = HttpURLConnection.HTTP_ACCEPTED;

    /**
     * HTTP Status-Code 204: 操作已经执行成功，但是没有返回数据
     */
    public static final int NO_CONTENT = HttpURLConnection.HTTP_NO_CONTENT;

    /**
     * HTTP Status-Code 301: 资源已被移除
     */
    public static final int MOVED_PERM = HttpURLConnection.HTTP_MOVED_PERM;

    /**
     * HTTP Status-Code 302: 临时重定向
     */
    public static final int HTTP_MOVED_TEMP = HttpURLConnection.HTTP_MOVED_TEMP;

    /**
     * HTTP Status-Code 303: 重定向
     */
    public static final int SEE_OTHER = HttpURLConnection.HTTP_SEE_OTHER;

    /**
     * HTTP Status-Code 304: 资源没有被修改
     */
    public static final int NOT_MODIFIED = HttpURLConnection.HTTP_NOT_MODIFIED;
    /**
     * HTTP Status-Code 305: 使用代理
     */
    public static final int HTTP_USE_PROXY = HttpURLConnection.HTTP_USE_PROXY;

    /**
     * HTTP Status-Code 400: 参数列表错误（缺少，格式不匹配）
     */
    public static final int BAD_REQUEST = HttpURLConnection.HTTP_BAD_REQUEST;

    /**
     * HTTP Status-Code 401: 未授权
     */
    public static final int UNAUTHORIZED = HttpURLConnection.HTTP_UNAUTHORIZED;
    /**
     * HTTP Status-Code 402: Payment Required.
     */
    public static final int HTTP_PAYMENT_REQUIRED = HttpURLConnection.HTTP_PAYMENT_REQUIRED;

    /**
     * HTTP Status-Code 403: 访问受限，授权过期
     */
    public static final int FORBIDDEN = HttpURLConnection.HTTP_FORBIDDEN;

    /**
     * HTTP Status-Code 404: 资源，服务未找到
     */
    public static final int NOT_FOUND = HttpURLConnection.HTTP_NOT_FOUND;

    /**
     * HTTP Status-Code 405: 不允许的http方法
     */
    public static final int BAD_METHOD = HttpURLConnection.HTTP_BAD_METHOD;

    /**
     * HTTP Status-Code 406: Not Acceptable.
     */
    public static final int HTTP_NOT_ACCEPTABLE = HttpURLConnection.HTTP_NOT_ACCEPTABLE;

    /**
     * HTTP Status-Code 407: Proxy Authentication Required.
     */
    public static final int HTTP_PROXY_AUTH = HttpURLConnection.HTTP_PROXY_AUTH;

    /**
     * HTTP Status-Code 408: Request Time-Out.
     */
    public static final int HTTP_CLIENT_TIMEOUT = HttpURLConnection.HTTP_CLIENT_TIMEOUT;

    /**
     * HTTP Status-Code 409: 资源冲突，或者资源被锁
     */
    public static final int CONFLICT = HttpURLConnection.HTTP_CONFLICT;

    /**
     * HTTP Status-Code 410: Gone.
     */
    public static final int HTTP_GONE = HttpURLConnection.HTTP_GONE;

    /**
     * HTTP Status-Code 411: Length Required.
     */
    public static final int HTTP_LENGTH_REQUIRED = HttpURLConnection.HTTP_LENGTH_REQUIRED;

    /**
     * HTTP Status-Code 412: Precondition Failed.
     */
    public static final int HTTP_PRECON_FAILED = HttpURLConnection.HTTP_PRECON_FAILED;

    /**
     * HTTP Status-Code 413: Request Entity Too Large.
     */
    public static final int HTTP_ENTITY_TOO_LARGE = HttpURLConnection.HTTP_ENTITY_TOO_LARGE;

    /**
     * HTTP Status-Code 414: Request-URI Too Large.
     */
    public static final int HTTP_REQ_TOO_LONG = HttpURLConnection.HTTP_REQ_TOO_LONG;

    /**
     * HTTP Status-Code 415: 不支持的数据，媒体类型
     */
    public static final int UNSUPPORTED_TYPE = HttpURLConnection.HTTP_UNSUPPORTED_TYPE;

    /**
     * HTTP Status-Code 500: 系统内部错误
     */
    public static final int ERROR = HttpURLConnection.HTTP_INTERNAL_ERROR;

    /**
     * HTTP Status-Code 501: 接口未实现
     */
    public static final int NOT_IMPLEMENTED = HttpURLConnection.HTTP_NOT_IMPLEMENTED;

    /**
     * HTTP Status-Code 502: 错误网关
     */
    public static final int HTTP_BAD_GATEWAY = HttpURLConnection.HTTP_BAD_GATEWAY;

    /**
     * HTTP Status-Code 503: 服务不可用
     */
    public static final int HTTP_UNAVAILABLE = HttpURLConnection.HTTP_UNAVAILABLE;

    /**
     * HTTP Status-Code 504: 网关超时
     */
    public static final int HTTP_GATEWAY_TIMEOUT = HttpURLConnection.HTTP_GATEWAY_TIMEOUT;

    /**
     * HTTP Status-Code 505: 不支持的HTTP版本
     */
    public static final int HTTP_VERSION = HttpURLConnection.HTTP_VERSION;
}
