package cn.net.wanmo.common.util;

import java.util.concurrent.TimeUnit;

public class ThreadUtil {
    public static Thread newThread(Runnable runnable, String name) {
        Thread t = newThread(runnable, name, false);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }

        return t;
    }

    public static Thread newThread(Runnable runnable, String name, boolean isDaemon) {
        Thread t = new Thread(null, runnable, name);
        t.setDaemon(isDaemon);
        return t;
    }

    public static boolean sleep(Number timeout, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(timeout.longValue());
            return true;
        } catch (InterruptedException var3) {
            return false;
        }
    }

    public static boolean sleep(Number millis) {
        return millis == null ? true : sleep(millis.longValue());
    }

    public static boolean sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            } catch (InterruptedException var3) {
                return false;
            }
        }

        return true;
    }
}
