package cn.net.wanmo.common.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class TimerUtil {

    /**
     * 定时任务， 延迟执行
     *
     * @param name      标题
     * @param timerTask 任务
     * @param delay     延迟时长（毫秒）
     * @return 定时器
     */
    public static Timer newTimer(String name, TimerTask timerTask, long delay) {
        return newTimer(name, timerTask, delay, true);
    }

    /**
     * 定时任务， 延迟执行
     *
     * @param name      标题
     * @param timerTask 任务
     * @param delay     延迟时长（毫秒）
     * @param isCancel  是否取消定时器
     * @return 定时器
     */
    public static Timer newTimer(String name, TimerTask timerTask, long delay, boolean isCancel) {
        Timer timer = new Timer(name);
        timer.schedule(timerTask, delay);

        if (isCancel) {
            timer.cancel();
        }
        return timer;
    }

    /**
     * 定时任务， 延迟并循环执行
     *
     * @param name      标题
     * @param timerTask 任务
     * @param delay     延迟时长（毫秒）
     * @param period    循环间隔时长（毫秒）
     * @return 定时器
     */
    public static Timer newTimer(String name, TimerTask timerTask, long delay, long period) {
        Timer timer = new Timer(name);
        timer.schedule(timerTask, delay, period);
        return timer;
    }


    /**
     * 定时任务， 指定时间执行
     *
     * @param name      标题
     * @param timerTask 任务
     * @param date      指定时间
     * @return 定时器
     */
    public static Timer newTimer(String name, TimerTask timerTask, Date date) {
        return newTimer(name, timerTask, date, true);
    }

    /**
     * 定时任务， 指定时间执行
     *
     * @param name      标题
     * @param timerTask 任务
     * @param date      指定时间
     * @param isCancel  是否取消定时器
     * @return 定时器
     */
    public static Timer newTimer(String name, TimerTask timerTask, Date date, boolean isCancel) {
        Timer timer = new Timer(name);
        timer.schedule(timerTask, date);

        if (isCancel) {
            timer.cancel();
        }
        return timer;
    }

    /**
     * 定时任务， 指定时间并循环执行
     *
     * @param name      标题
     * @param timerTask 任务
     * @param date      指定时间
     * @param period    循环间隔时长（毫秒）
     * @return 定时器
     */
    public static Timer newTimer(String name, TimerTask timerTask, Date date, long period) {
        Timer timer = new Timer(name);
        timer.schedule(timerTask, date, period);
        return timer;
    }
}
