package cn.net.wanmo.common.util;

import org.apache.commons.lang3.ObjectUtils;

public class ObjectUtil extends ObjectUtils {

    @SuppressWarnings("unchecked")
    public static <T> T cast(Object obj) {
        return (T) obj;
    }

    /**
     * * 判断一个对象是否为空
     *
     * @param object Object
     * @return true：为空 false：非空
     */
    public static boolean isNull(Object object) {
        return object == null;
    }

    /**
     * * 判断一个对象是否非空
     *
     * @param object Object
     * @return true：非空 false：空
     */
    public static boolean isNotNull(Object object) {
        return isNull(object) == false;
    }

    /**
     * * 判断一个对象是否是数组类型（Java基本型别的数组）
     *
     * @param object 对象
     * @return true：是数组 false：不是数组
     */
    public static boolean isArray(Object object) {
        return isNotNull(object) && object.getClass().isArray();
    }


    public static boolean isBlank(Object object) {
        if (isNull(object)) {
            return true;
        }

        String s = object.toString().trim();
        if (StringUtil.isBlank(s)) {
            return true;
        }

        return false;
    }

    public static boolean isNotBlank(Object object) {
        return isBlank(object) == false;

    }
}
