/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.result;

import cn.net.wanmo.common.util.JacksonMapper;
import cn.net.wanmo.common.util.ObjectUtil;
import cn.net.wanmo.common.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;

public class WanMoResult<T>
extends HashMap<String, Object>
implements Serializable {
    protected static final long serialVersionUID = 1L;
    public static final String CODE_TAG = "code";
    public static final String MSG_TAG = "msg";
    public static final String DESC_TAG = "desc";
    public static final String DATA_TAG = "data";
    public static final String CONSUME_TIME_TAG = "consumeTime";
    public static String DEFAULT_SUCCESS_CODE = "success";
    public static String DEFAULT_SUCCESS_MSG = "\u64cd\u4f5c\u6210\u529f";
    public static String DEFAULT_FAIL_CODE = "fail";
    public static String DEFAULT_ERROR_CODE = "error";
    public static String DEFAULT_ERROR_MSG = "\u64cd\u4f5c\u5931\u8d25";

    public WanMoResult() {
    }

    public WanMoResult(String code, String msg) {
        super.put(CODE_TAG, code);
        super.put(MSG_TAG, msg);
    }

    public WanMoResult(String code, String msg, T data) {
        this(code, msg);
        super.put(DATA_TAG, data);
    }

    public static WanMoResult success() {
        return WanMoResult.success(DEFAULT_SUCCESS_MSG);
    }

    public static WanMoResult success(String msg) {
        return new WanMoResult<Object>(DEFAULT_SUCCESS_CODE, msg, null);
    }

    public static <T> WanMoResult success(T data) {
        return WanMoResult.success(DEFAULT_SUCCESS_MSG, data);
    }

    public static <T> WanMoResult success(String msg, T data) {
        return new WanMoResult<T>(DEFAULT_SUCCESS_CODE, msg, data);
    }

    public static WanMoResult error() {
        return WanMoResult.error(DEFAULT_ERROR_MSG);
    }

    public static WanMoResult error(String msg) {
        return new WanMoResult<Object>(DEFAULT_ERROR_CODE, msg, null);
    }

    public static <T> WanMoResult error(String msg, T data) {
        return new WanMoResult<T>(DEFAULT_ERROR_CODE, msg, data);
    }

    public static WanMoResult fail(String msg) {
        return new WanMoResult<Object>(DEFAULT_FAIL_CODE, msg, null);
    }

    public static WanMoResult fail(String code, String msg) {
        return new WanMoResult<Object>(code, msg, null);
    }

    public boolean isSuccess() {
        return StringUtil.equals((CharSequence)DEFAULT_SUCCESS_CODE, (CharSequence)this.getCode());
    }

    @Override
    public WanMoResult put(String key, Object value) {
        super.put(key, value);
        return this;
    }

    public WanMoResult setCode(String code) {
        return this.put(CODE_TAG, (Object)code);
    }

    public String getCode() {
        String value = this.getOrDefault(CODE_TAG, "");
        return value.toString();
    }

    public WanMoResult setMsg(String msg) {
        return this.put(MSG_TAG, (Object)msg);
    }

    public String getMsg() {
        String value = this.getOrDefault(MSG_TAG, "");
        return value.toString();
    }

    public WanMoResult setDesc(String desc) {
        return this.put(DESC_TAG, (Object)desc);
    }

    public String getDesc() {
        String value = this.getOrDefault(DESC_TAG, "");
        return value.toString();
    }

    public WanMoResult setConsumeTime(Integer consumeTime) {
        return this.put(CONSUME_TIME_TAG, (Object)consumeTime);
    }

    public Integer getConsumeTime() {
        String value = this.getOrDefault(CONSUME_TIME_TAG, "0");
        Integer consumeTime = Integer.valueOf(value.toString());
        return consumeTime;
    }

    public WanMoResult setData(T data) {
        return this.put(DATA_TAG, data);
    }

    public T getData() {
        return ObjectUtil.cast(this.get(DATA_TAG));
    }

    public String getTip() {
        this.put("success", (Object)this.isSuccess());
        return JacksonMapper.toJson(this);
    }
}

