/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class DateTimeUtil {
    public static Long nowMillisecond() {
        return DateTimeUtil.toMillisecond(DateTimeUtil.nowLocalDateTime());
    }

    public static Date nowDate() {
        return DateTimeUtil.toDate(DateTimeUtil.nowLocalDateTime());
    }

    public static LocalDate nowLocalDate() {
        return LocalDate.now(DateTimeUtil.getZoneIdDefault());
    }

    public static LocalTime nowLocalTime() {
        return LocalTime.now(DateTimeUtil.getZoneIdDefault());
    }

    public static LocalDateTime nowLocalDateTime() {
        return LocalDateTime.now(DateTimeUtil.getZoneIdDefault());
    }

    public static String nowDay() {
        return DateTimeUtil.formatDay(DateTimeUtil.nowLocalDate());
    }

    public static String nowTime() {
        return DateTimeUtil.formatTime(DateTimeUtil.nowLocalTime());
    }

    public static String nowDayTime() {
        return DateTimeUtil.formatDayTime(DateTimeUtil.nowLocalDateTime());
    }

    public static String formatTime(LocalTime localTime) {
        return DateTimeUtil.formatTime(localTime, "HH:mm:ss");
    }

    public static String formatTime(LocalTime localTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return localTime.format(formatter);
    }

    public static String formatTime(LocalDateTime localDateTime) {
        LocalTime localTime = localDateTime.toLocalTime();
        return DateTimeUtil.formatTime(localTime);
    }

    public static String formatTime(Date date) {
        LocalTime localTime = DateTimeUtil.toLocalTime(date);
        return DateTimeUtil.formatTime(localTime);
    }

    public static String formatDay(LocalDate localDate) {
        return DateTimeUtil.formatDay(localDate, "yyyy-MM-dd");
    }

    public static String formatDay(LocalDate localDate, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return localDate.format(formatter);
    }

    public static String formatDay(LocalDateTime localDateTime) {
        LocalDate localDate = localDateTime.toLocalDate();
        return DateTimeUtil.formatDay(localDate);
    }

    public static String formatDay(Date date) {
        LocalDate localDate = DateTimeUtil.toLocalDate(date);
        return DateTimeUtil.formatDay(localDate);
    }

    public static String formatDayTime(LocalDateTime localDateTime) {
        return DateTimeUtil.formatDayTime(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDayTime(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return localDateTime.format(formatter);
    }

    public static String formatDayTime(Date date) {
        LocalDateTime localDateTime = DateTimeUtil.toLocalDateTime(date);
        return DateTimeUtil.formatDayTime(localDateTime);
    }

    public static String formatDate(Date date, String pattern) {
        LocalDateTime localDateTime = DateTimeUtil.toLocalDateTime(date);
        return DateTimeUtil.formatDayTime(localDateTime, pattern);
    }

    public static LocalDate parseLocalDate(String date) {
        return LocalDate.parse(date);
    }

    public static LocalDate parseLocalDate(String date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return LocalDate.parse(date, formatter);
    }

    public static LocalTime parseLocalTime(String time) {
        return LocalTime.parse(time);
    }

    public static LocalTime parseLocalTime(String time, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return LocalTime.parse(time, formatter);
    }

    public static LocalDateTime parseLocalDateTime(String date) {
        return LocalDateTime.parse(date);
    }

    public static LocalDateTime parseLocalDateTime(String date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.CHINA);
        return LocalDateTime.parse(date, formatter);
    }

    public static Date parseDate(String date) {
        LocalDateTime localDateTime = DateTimeUtil.parseLocalDateTime(date);
        return DateTimeUtil.toDate(localDateTime);
    }

    public static Date parseDate(String date, String pattern) {
        LocalDateTime localDateTime = DateTimeUtil.parseLocalDateTime(date, pattern);
        return DateTimeUtil.toDate(localDateTime);
    }

    public static Date toDate(LocalDate localDate) {
        return DateTimeUtil.toDate(localDate, null);
    }

    public static Date toDate(LocalDate localDate, LocalTime localTime) {
        LocalDateTime localDateTime = null;
        localDateTime = localTime == null ? localDate.atStartOfDay() : localDate.atTime(localTime);
        return DateTimeUtil.toDate(localDateTime);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(DateTimeUtil.getZoneIdDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        LocalDateTime localDateTime = DateTimeUtil.toLocalDateTime(date);
        return localDateTime.toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        LocalDateTime localDateTime = DateTimeUtil.toLocalDateTime(date);
        return localDateTime.toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), DateTimeUtil.getZoneIdDefault());
    }

    public static Long toMillisecond(Date date) {
        return date.getTime();
    }

    public static Long toMillisecond(LocalDateTime localDateTime) {
        return DateTimeUtil.toMillisecond(localDateTime, DateTimeUtil.getZoneIdDefault());
    }

    public static Long toMillisecond(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static LocalDateTime minusDays(long days) {
        return DateTimeUtil.nowLocalDateTime().minusDays(days);
    }

    public static LocalDateTime minusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.minusDays(days);
    }

    public static LocalDateTime plusDays(long days) {
        return DateTimeUtil.nowLocalDateTime().plusDays(days);
    }

    public static LocalDateTime plusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.plusDays(days);
    }

    public static boolean isEqual(LocalDate localDate1, LocalDate localDate2) {
        return localDate1.isEqual(localDate2);
    }

    public static boolean isEqual(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        return localDateTime1.isEqual(localDateTime2);
    }

    public static boolean inRangeNowDay(int beginYear, int beginMonth, int beginDayOfMonth, int endYear, int endMonth, int endDayOfMonth) {
        LocalDate now = DateTimeUtil.nowLocalDate();
        LocalDate begin = LocalDate.of(beginYear, beginMonth, beginDayOfMonth);
        LocalDate end = LocalDate.of(endYear, endMonth, endDayOfMonth);
        return now.isAfter(begin) && now.isBefore(end);
    }

    public static boolean inRangeNowTime(int beginHour, int beginMinute, int beginSecond, int endHour, int endMinute, int endSecond) {
        LocalTime now = DateTimeUtil.nowLocalTime();
        LocalTime begin = LocalTime.of(beginHour, beginMinute, beginSecond);
        LocalTime end = LocalTime.of(endHour, endMinute, endSecond);
        return now.isAfter(begin) && now.isBefore(end);
    }

    public static boolean inRangeNow(int beginYear, int beginMonth, int beginDayOfMonth, int beginHour, int beginMinute, int beginSecond, int endYear, int endMonth, int endDayOfMonth, int endHour, int endMinute, int endSecond) {
        LocalDateTime now = DateTimeUtil.nowLocalDateTime();
        Long nowLong = DateTimeUtil.toMillisecond(now);
        LocalDateTime begin = LocalDateTime.of(beginYear, beginMonth, beginDayOfMonth, beginHour, beginMinute, beginSecond);
        Long beginLong = DateTimeUtil.toMillisecond(begin);
        LocalDateTime end = LocalDateTime.of(endYear, endMonth, endDayOfMonth, endHour, endMinute, endSecond);
        Long endLong = DateTimeUtil.toMillisecond(end);
        return beginLong < nowLong && nowLong < endLong;
    }

    public static long betweenYears(LocalDate begin, LocalDate end) {
        Period period = Period.between(begin, end);
        return period.getYears();
    }

    public static long betweenMonths(LocalDate begin, LocalDate end) {
        Period period = Period.between(begin, end);
        return period.toTotalMonths();
    }

    public static long betweenDays(LocalDateTime begin, LocalDateTime end) {
        Duration duration = Duration.between(begin, end);
        return duration.toDays();
    }

    public static long betweenHours(LocalDateTime begin, LocalDateTime end) {
        Duration duration = Duration.between(begin, end);
        return duration.toHours();
    }

    public static long betweenMinutes(LocalDateTime begin, LocalDateTime end) {
        Duration duration = Duration.between(begin, end);
        return duration.toMinutes();
    }

    public static ZoneId getZoneIdDefault() {
        return DateTimeUtil.getZoneIdDefault_02();
    }

    private static ZoneId getZoneIdDefault_01() {
        return ZoneId.of("Asia/Shanghai");
    }

    private static ZoneId getZoneIdDefault_02() {
        return ZoneId.of(ZoneId.SHORT_IDS.get("CTT"));
    }

    public static void printZoneIds() {
        Set<String> zoneIds = ZoneId.getAvailableZoneIds();
        zoneIds.stream().iterator().forEachRemaining(s -> System.out.println((String)s));
    }
}

