/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import cn.net.wanmo.common.util.StringUtil;
import com.google.common.io.Resources;
import java.net.URL;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ini4jUtil {
    private static Logger logger = LoggerFactory.getLogger(Ini4jUtil.class);
    public static Ini iniDefault = null;

    public static Profile.Section getSection(Ini ini, String sectionName) {
        return Ini4jUtil.getSection(ini, sectionName, null);
    }

    public static Profile.Section getSection(Ini ini, String sectionName, Integer index) {
        if (ini == null || StringUtil.isBlank((CharSequence)sectionName)) {
            return null;
        }
        if (index == null) {
            return (Profile.Section)ini.get((Object)sectionName);
        }
        return (Profile.Section)ini.get((Object)sectionName, index.intValue());
    }

    public static Profile.Section getSection(String sectionName, Integer index) {
        return Ini4jUtil.getSection(iniDefault, sectionName, index);
    }

    public static Profile.Section getSection(String sectionName) {
        return Ini4jUtil.getSection(sectionName, null);
    }

    public static String getValue(Profile.Section section, String key) {
        if (section == null || StringUtil.isBlank((CharSequence)key)) {
            return null;
        }
        return (String)section.get((Object)key);
    }

    public static Ini getIni(String fileName) {
        Ini ini = null;
        try {
            Config cfg = new Config();
            cfg.setMultiSection(true);
            URL url = Resources.getResource((String)fileName);
            ini = new Ini();
            ini.setConfig(cfg);
            ini.load(url);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff1a %s", fileName), e);
        }
        return ini;
    }

    static {
        try {
            iniDefault = Ini4jUtil.getIni("config/wanmo-config.ini");
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }
}

