/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonMapper
extends ObjectMapper {
    private static Logger logger = LoggerFactory.getLogger(JacksonMapper.class);
    private static JacksonMapper mapper = null;

    public JacksonMapper() {
        this(JsonInclude.Include.NON_EMPTY);
    }

    public JacksonMapper(JsonInclude.Include include) {
        if (Objects.nonNull(include)) {
            this.setSerializationInclusion(include);
        }
        this.enableSimple();
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString("");
            }
        });
        this.registerModule((Module)new SimpleModule().addSerializer(String.class, (JsonSerializer)new JsonSerializer<String>(){

            public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeString(StringEscapeUtils.unescapeHtml4((String)value));
            }
        }));
        this.setTimeZone(TimeZone.getDefault());
    }

    public JacksonMapper enableSimple() {
        this.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        return this;
    }

    public static JacksonMapper getMapper() {
        if (mapper == null) {
            mapper = new JacksonMapper().enableSimple();
        }
        return mapper;
    }

    public static JacksonMapper nonDefaultMapper() {
        if (mapper == null) {
            mapper = new JacksonMapper(JsonInclude.Include.NON_DEFAULT);
        }
        return mapper;
    }

    public static String toJson(Object obj) {
        String json = "";
        try {
            json = JacksonMapper.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.warn("write to json string error:" + obj, (Throwable)e);
        }
        return json;
    }

    public static <T> T fromJson(byte[] json, Class<T> clazz) {
        try {
            return (T)JacksonMapper.getMapper().readValue(json, clazz);
        }
        catch (IOException e) {
            logger.warn("parse json string error:", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(InputStream json, Class<T> valueType) {
        try {
            return (T)JacksonMapper.getMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            logger.warn("parse json string error:", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        try {
            return (T)JacksonMapper.getMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + json, (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(File json, Class<T> valueType) {
        try {
            return (T)JacksonMapper.getMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + json, (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, JavaType javaType) throws Exception {
        return (T)JacksonMapper.getMapper().readValue(json, javaType);
    }

    public static <T> T jsonToList(String json, Class<T> valueType) throws Exception {
        JavaType javaType = JacksonMapper.getCollectionType(ArrayList.class, valueType);
        return (T)mapper.readValue(json, javaType);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> void writeJson(File file, T value) {
        try {
            JacksonMapper.getMapper().writeValue(file, value);
        }
        catch (IOException e) {
            logger.warn("write json to file error:", (Throwable)e);
        }
    }

    public static JsonNode toNode(String content) throws IOException {
        return JacksonMapper.getMapper().readTree(content);
    }

    public static ObjectNode createObjectNode(Map<String, String> map) {
        ObjectNode jsonObject = JacksonMapper.getMapper().createObjectNode();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            jsonObject.put(key, value);
        }
        return jsonObject;
    }

    public static void main(String[] args) {
        String json = "{\"access_token\":\"8x_u-fYL2ZrmiitGIQTRxb6UpZr8uAWQHEd-Cp4NQB1_P_nrw3kLyDAklwbWK3W7SIgHcc1_DZ2paxz8DR34I3UYy66IcPDlqOSpNOpjN1gzvy4nIeDxF3_W8Zq6DTZ_IBOaAIAEXK\",\"expires_in\":7200}";
        Map map = JacksonMapper.fromJson(json, Map.class);
        System.out.println(map);
    }
}

