package cn.net.wanmo.common.cert;

import java.io.Serializable;

public class CertOption implements Serializable {
    // 证书申请单位所在地：所在国家 (Country) 简称：C 字段，只能是国家字母缩写，如中国：CN
    private String c = "CN";
    // 证书申请单位所在地：所在省份 (State/Provice) 简称：S 字段
    private String s;
    // 证书申请单位所在地：所在城市 (Locality) 简称：L 字段
    private String l;
    // 单位名称 (Organization Name) ：简称：O 字段，对于 SSL 证书，一般为网站域名；而对于代码签名证书则为申请单位名称；而对于客户端单位证书则为证书申请者所在单位名称；
    private String o;
    // 公用名称 (Common Name) 简称：CN 字段，对于 SSL 证书，一般为网站域名或IP地址；而对于代码签名证书则为申请单位名称；而对于客户端证书则为证书申请者的姓名；
    private String cn;
    // 其他一些字段：多个姓名字段 简称：G 字段
    private String g;
    // 其他一些字段：显示其他内容 简称：OU 字段
    private String ou;
    // 其他一些字段：电子邮件 (Email) 简称：E 字段
    private String e;
    // 其他一些字段：电话号码：Phone 字段，格式要求 + 国家区号 城市区号 电话号码，如： +86 732 88888888
    private String phone;
    // 其他一些字段：地址：STREET  字段
    private String street;
    // 其他一些字段：邮政编码：PostalCode 字段
    private String postalCode;
    // 其他一些字段：介绍：Description 字段
    private String description;

    public CertOption() {
    }

    public String getCn() {
        return cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getO() {
        return o;
    }

    public void setO(String o) {
        this.o = o;
    }

    public String getL() {
        return l;
    }

    public void setL(String l) {
        this.l = l;
    }

    public String getS() {
        return s;
    }

    public void setS(String s) {
        this.s = s;
    }

    public String getC() {
        return c;
    }

    public void setC(String c) {
        this.c = c;
    }

    public String getE() {
        return e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public String getG() {
        return g;
    }

    public void setG(String g) {
        this.g = g;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getStreet() {
        return street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getOu() {
        return ou;
    }

    public void setOu(String ou) {
        this.ou = ou;
    }
}
