package cn.net.wanmo.common.keytool;

import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;

public class KeytoolUtil {
    /**
     * 获取 KeyStore
     * @param type 为空，则使用默认值， 如：JKS
     * @param jksFilePath 文件路径
     * @param jkdPassword 密码
     * @return KeyStore
     */
    public static KeyStore getKeyStore(String type, String jksFilePath, String jkdPassword) {
        try (InputStream inputStream = new FileInputStream(jksFilePath)){
            KeyStore ks = KeyStore.getInstance(StringUtil.isBlank(type) ? KeyStore.getDefaultType() : type);
            //加载keytool生成的密钥库，其中包括证书链
            ks.load(inputStream, jkdPassword.toCharArray());
            return ks;
        } catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }


    /**
     * 获取 SSLContext
     * @param type 如：TLS
     * @param keyStore  KeyStore
     * @param password  KeyStore 密码
     * @return SSLContext
     */
    public static SSLContext getSSLContext(String type, KeyStore keyStore, char[] password) {
        try {
            SSLContext sslContext = SSLContext.getInstance(type);

            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password);
            sslContext.init(kmf.getKeyManagers(), null, null);

            return sslContext;
        } catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }
}
