/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import cn.net.wanmo.common.util.CharsetUtil;
import cn.net.wanmo.common.util.CodecUtil;
import cn.net.wanmo.common.util.StringUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    static Logger logger = LoggerFactory.getLogger(AesUtil.class);
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String CIPHER_ALGORITHM_ECB = "AES/ECB/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";

    public static String encryptByECB(String keyStr, String data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_ECB);
        SecretKeySpec key = new SecretKeySpec(CodecUtil.decodeBase64(keyStr), KEY_ALGORITHM_AES);
        cipher.init(1, key);
        byte[] result = cipher.doFinal(data.getBytes(CharsetUtil.DEFAULT_CHARSET));
        return CodecUtil.encodeBase64(result);
    }

    public static String decryptByECB(String keyStr, String data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_ECB);
        SecretKeySpec key = new SecretKeySpec(CodecUtil.decodeBase64(keyStr), KEY_ALGORITHM_AES);
        cipher.init(2, key);
        byte[] decryptBytes = cipher.doFinal(CodecUtil.decodeBase64(data));
        return StringUtil.toEncodedString((byte[])decryptBytes, (Charset)CharsetUtil.DEFAULT_CHARSET);
    }

    public static String encryptByCBC(String keyStr, String ivStr, String data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
        SecretKeySpec key = new SecretKeySpec(CodecUtil.decodeBase64(keyStr), KEY_ALGORITHM_AES);
        IvParameterSpec iv = new IvParameterSpec(CodecUtil.decodeBase64(ivStr));
        cipher.init(1, (Key)key, iv);
        byte[] encryptBytes = cipher.doFinal(data.getBytes(CharsetUtil.DEFAULT_CHARSET));
        return CodecUtil.encodeBase64(encryptBytes);
    }

    public static String decryptByCBC(String keyStr, String ivStr, String data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
        SecretKeySpec key = new SecretKeySpec(CodecUtil.decodeBase64(keyStr), KEY_ALGORITHM_AES);
        IvParameterSpec iv = new IvParameterSpec(CodecUtil.decodeBase64(ivStr));
        cipher.init(2, (Key)key, iv);
        byte[] decryptBytes = cipher.doFinal(CodecUtil.decodeBase64(data));
        return StringUtil.toEncodedString((byte[])decryptBytes, (Charset)CharsetUtil.DEFAULT_CHARSET);
    }

    public static String keyGenerate() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
        keyGenerator.init(new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        return CodecUtil.encodeBase64(keyBytes);
    }
}

