/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;

public class BeanValidatorUtil {
    public static void validateWithException(Validator validator, Object object, Class<?> ... groups) throws ConstraintViolationException {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static List<String> extractMessage(ConstraintViolationException e) {
        return BeanValidatorUtil.extractMessage(e.getConstraintViolations());
    }

    public static List<String> extractMessage(Set<? extends ConstraintViolation> constraintViolations) {
        ArrayList errorMessages = Lists.newArrayList();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            errorMessages.add(constraintViolation.getMessage());
        }
        return errorMessages;
    }

    public static Map<String, String> extractPropertyAndMessage(ConstraintViolationException e) {
        return BeanValidatorUtil.extractPropertyAndMessage(e.getConstraintViolations());
    }

    public static Map<String, String> extractPropertyAndMessage(Set<? extends ConstraintViolation> constraintViolations) {
        HashMap errorMessages = Maps.newHashMap();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            errorMessages.put(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage());
        }
        return errorMessages;
    }

    public static List<String> extractPropertyAndMessageAsList(ConstraintViolationException e) {
        return BeanValidatorUtil.extractPropertyAndMessageAsList(e.getConstraintViolations(), " ");
    }

    public static List<String> extractPropertyAndMessageAsList(Set<? extends ConstraintViolation> constraintViolations) {
        return BeanValidatorUtil.extractPropertyAndMessageAsList(constraintViolations, " ");
    }

    public static List<String> extractPropertyAndMessageAsList(ConstraintViolationException e, String separator) {
        return BeanValidatorUtil.extractPropertyAndMessageAsList(e.getConstraintViolations(), separator);
    }

    public static List<String> extractPropertyAndMessageAsList(Set<? extends ConstraintViolation> constraintViolations, String separator) {
        ArrayList errorMessages = Lists.newArrayList();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            errorMessages.add(constraintViolation.getPropertyPath() + separator + constraintViolation.getMessage());
        }
        return errorMessages;
    }
}

