/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.FileUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.util.SystemUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class LogUtil {
    public static final String track = "track";
    public static final String debug = "debug";
    public static final String info = "info";
    public static final String warn = "warn";
    public static final String error = "error";
    public static final String CONSOLE = "appender_console";
    public static final String FILE = "appender_file";
    public static String LOG_LEVEV = "debug";

    public static void track(String s) {
        LogUtil.track(CONSOLE, s);
    }

    public static void track(String appender, String s) {
        LogUtil.trackFormat(appender, s, new Object[0]);
    }

    public static void trackFormat(String appender, String format, Object ... args) {
        List<String> levelList = Arrays.asList(track);
        if (levelList.contains(LOG_LEVEV)) {
            String logStr = "\u8ddf\u8e2a\u65e5\u5fd7\uff1a" + LogUtil.printPrev(track) + String.format(format, args);
            LogUtil.outputLog(appender, logStr);
        }
    }

    public static void debug(String s) {
        LogUtil.debug(CONSOLE, s);
    }

    public static void debug(String appender, String s) {
        LogUtil.debugFormat(appender, s, new Object[0]);
    }

    public static void debugFormat(String appender, String format, Object ... args) {
        List<String> levelList = Arrays.asList(track, debug);
        if (levelList.contains(LOG_LEVEV)) {
            String logStr = "\u8c03\u8bd5\u65e5\u5fd7\uff1a" + LogUtil.printPrev(debug) + String.format(format, args);
            LogUtil.outputLog(appender, logStr);
        }
    }

    public static void info(String s) {
        LogUtil.info(CONSOLE, s);
    }

    public static void info(String appender, String s) {
        LogUtil.infoFormat(appender, s, new Object[0]);
    }

    public static void infoFormat(String appender, String format, Object ... args) {
        List<String> levelList = Arrays.asList(track, debug, info);
        if (levelList.contains(LOG_LEVEV)) {
            String logStr = "\u4fe1\u606f\u65e5\u5fd7\uff1a" + LogUtil.printPrev(info) + String.format(format, args);
            LogUtil.outputLog(appender, logStr);
        }
    }

    public static void warn(String s) {
        LogUtil.warn(CONSOLE, s);
    }

    public static void warn(String appender, String s) {
        LogUtil.warnFormat(appender, s, new Object[0]);
    }

    public static void warnFormat(String appender, String format, Object ... args) {
        List<String> levelList = Arrays.asList(track, debug, info, warn);
        if (levelList.contains(LOG_LEVEV)) {
            String logStr = "\u8b66\u544a\u65e5\u5fd7\uff1a" + LogUtil.printPrev(warn) + String.format(format, args);
            LogUtil.outputLog(appender, logStr);
        }
    }

    public static void error(String s) {
        LogUtil.error(CONSOLE, s);
    }

    public static void error(String appender, String s) {
        LogUtil.errorFormat(appender, s, new Object[0]);
    }

    public static void errorFormat(String appender, String format, Object ... args) {
        List<String> levelList = Arrays.asList(track, debug, info, warn, error);
        if (levelList.contains(LOG_LEVEV)) {
            String logStr = "\u9519\u8bef\u65e5\u5fd7\uff1a" + LogUtil.printPrev(error) + String.format(format, args);
            LogUtil.outputLog(appender, logStr);
        }
    }

    private static String printPrev(String level) {
        Date date = new Date();
        String prev = String.format(level + ": %tF %tT %n", date, date);
        return prev;
    }

    public static void outputLog(String appender, String logStr) {
        if (StringUtil.equals((CharSequence)CONSOLE, (CharSequence)appender)) {
            System.out.println(logStr);
            System.out.println("");
        }
        if (StringUtil.equals((CharSequence)FILE, (CharSequence)appender)) {
            FileUtil.writeToFile(LogUtil.getLogFileName(), logStr + "\r\n", true);
            FileUtil.writeToFile(LogUtil.getLogFileName(), "\r\n", true);
        }
    }

    private static String getLogFileName() {
        String logFileName = "";
        if (SystemUtil.isWindows()) {
            logFileName = "c:/wammologs/" + DateUtil.formatDay() + ".log";
        }
        if (SystemUtil.isLinux()) {
            logFileName = "/var/wammologs/" + DateUtil.formatDay() + ".log";
        }
        if (SystemUtil.isMacOS() || SystemUtil.isMacOSX()) {
            logFileName = "/var/wammologs/" + DateUtil.formatDay() + ".log";
        }
        return logFileName;
    }
}

