/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.crypto;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    static Logger logger = LoggerFactory.getLogger(AesUtil.class);
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String CIPHER_ALGORITHM_ECB = "AES/ECB/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";

    public static String encrypt(String data, String keyStr) {
        return AesUtil.encrypt(data, keyStr, null);
    }

    public static String encrypt(String data, String keyStr, String ivStr) {
        try {
            Cipher cipher = AesUtil.getCipher(1, keyStr, ivStr);
            byte[] encryptBytes = cipher.doFinal(data.getBytes(CharsetUtil.DEFAULT));
            return CodecUtil.encodeBase64(encryptBytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String decrypt(String data, String keyStr) {
        return AesUtil.decrypt(data, keyStr, null);
    }

    public static String decrypt(String data, String keyStr, String ivStr) {
        try {
            Cipher cipher = AesUtil.getCipher(2, keyStr, ivStr);
            byte[] decryptBytes = cipher.doFinal(CodecUtil.decodeBase64(data));
            return StringUtil.toEncodedString((byte[])decryptBytes, (Charset)CharsetUtil.DEFAULT);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    private static Cipher getCipher(int mode, String key, String iv) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(CodecUtil.decodeBase64(key), KEY_ALGORITHM_AES);
            Cipher cipher = null;
            if (StringUtil.isBlank((CharSequence)iv)) {
                cipher = Cipher.getInstance(CIPHER_ALGORITHM_ECB);
                cipher.init(mode, secretKeySpec);
            } else {
                cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(CodecUtil.decodeBase64(iv));
                cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            }
            return cipher;
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String keyGenerate() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] keyBytes = secretKey.getEncoded();
            return CodecUtil.encodeBase64(keyBytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String generateKey() {
        return AesUtil.keyGenerate();
    }

    public static String generateIv() {
        return AesUtil.keyGenerate();
    }

    public static String getRandomKey() {
        String randomCode = StringUtil.getRandomCode(16);
        return CodecUtil.encodeBase64(randomCode);
    }

    public static String getRandomIv() {
        String randomCode = StringUtil.getRandomCode(16);
        return CodecUtil.encodeBase64(randomCode);
    }
}

