/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.crypto;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DesUtil {
    private static final String KEY_ALGORITHM_DES = "DES";
    private static final String CIPHER_ALGORITHM_ECB = "DES/ECB/PKCS5Padding";
    private static final String CIPHER_ALGORITHM_CBC = "DES/CBC/PKCS5Padding";

    public static String encipher(String data, String key) {
        return DesUtil.encipher(data, key, null);
    }

    public static String encipher(String data, String key, String iv) {
        try {
            Cipher cipher = DesUtil.getCipher(1, key, iv);
            byte[] bytes = cipher.doFinal(data.getBytes(CharsetUtil.DEFAULT));
            return CodecUtil.encodeBase64(bytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String decrypt(String data, String key) {
        return DesUtil.decrypt(data, key, null);
    }

    public static String decrypt(String data, String key, String iv) {
        try {
            Cipher cipher = DesUtil.getCipher(2, key, iv);
            byte[] bytes = cipher.doFinal(CodecUtil.decodeBase64(data));
            return StringUtil.toEncodedString((byte[])bytes, (Charset)CharsetUtil.DEFAULT);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    private static Cipher getCipher(int mode, String key, String iv) {
        try {
            Cipher cipher;
            SecretKeySpec secretKeySpec = new SecretKeySpec(CodecUtil.decodeBase64(key), KEY_ALGORITHM_DES);
            if (StringUtil.isBlank((CharSequence)iv)) {
                cipher = Cipher.getInstance(CIPHER_ALGORITHM_ECB);
                cipher.init(mode, secretKeySpec);
            } else {
                cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(CodecUtil.decodeBase64(iv));
                cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            }
            return cipher;
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String keyGenerate() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM_DES);
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] keyBytes = secretKey.getEncoded();
            return CodecUtil.encodeBase64(keyBytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String generateKey() {
        return DesUtil.keyGenerate();
    }

    public static String generateIv() {
        return DesUtil.keyGenerate();
    }

    public static String getRandomKey() {
        String randomCode = StringUtil.getRandomCode(8);
        return CodecUtil.encodeBase64(randomCode);
    }

    public static String getRandomIv() {
        String randomCode = StringUtil.getRandomCode(8);
        return CodecUtil.encodeBase64(randomCode);
    }
}

