/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.crypto.rsa;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.crypto.pojo.KeyPairBase64;
import cn.net.wanmo.common.crypto.pojo.KeyPairFiles;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.FileUtil;
import cn.net.wanmo.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RsaUtil {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SHA256_WITH_RSA = "sha256withrsa";

    public static KeyPair getKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static KeyPairBase64 getKeyPairBase64() {
        KeyPair keyPair = RsaUtil.getKeyPair();
        byte[] privateEncoded = keyPair.getPrivate().getEncoded();
        byte[] publicEncoded = keyPair.getPublic().getEncoded();
        String privateEncodedBase64 = CodecUtil.encodeBase64(privateEncoded);
        String publicEncodedBase64 = CodecUtil.encodeBase64(publicEncoded);
        return new KeyPairBase64(publicEncodedBase64, privateEncodedBase64);
    }

    public static KeyPairFiles getKeyPairFiles(String pubFilePath, String priFilePath) {
        return RsaUtil.getKeyPairFiles(pubFilePath, priFilePath, CharsetUtil.DEFAULT);
    }

    public static KeyPairFiles getKeyPairFiles(String pubFilePath, String priFilePath, Charset charset) {
        try {
            KeyPairBase64 keyPairBase64 = RsaUtil.getKeyPairBase64();
            KeyPairFiles keyPairFiles = new KeyPairFiles(pubFilePath, priFilePath);
            FileUtil.writeStringToFile((File)keyPairFiles.getPublicKey(), (String)keyPairBase64.getPublicKey(), (Charset)charset);
            FileUtil.writeStringToFile((File)keyPairFiles.getPrivateKey(), (String)keyPairBase64.getPrivateKey(), (Charset)charset);
            return keyPairFiles;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PublicKey getPublicKeyByBase64(String publicKeyBase64) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(CodecUtil.decodeBase64(publicKeyBase64));
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PrivateKey getPrivateKeyByBase64(String privateKeyBase64) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(CodecUtil.decodeBase64(privateKeyBase64));
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PrivateKey getPrivateKeyByFilePath(String priFilePath) {
        return RsaUtil.getPrivateKeyByFilePath(priFilePath, CharsetUtil.DEFAULT);
    }

    public static PrivateKey getPrivateKeyByFilePath(String priFilePath, Charset charset) {
        return RsaUtil.getPrivateKeyByFile(FileUtil.getFile((String[])new String[]{priFilePath}), charset);
    }

    public static PrivateKey getPrivateKeyByFile(File priFile) {
        return RsaUtil.getPrivateKeyByFile(priFile, CharsetUtil.DEFAULT);
    }

    public static PrivateKey getPrivateKeyByFile(File priFile, Charset charset) {
        try {
            String privateKeyBase64 = FileUtil.readFileToString((File)priFile, (Charset)charset);
            return RsaUtil.getPrivateKeyByBase64(privateKeyBase64);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static PublicKey getPublicKeyByFilePath(String pubFilePath) {
        return RsaUtil.getPublicKeyByFilePath(pubFilePath, CharsetUtil.DEFAULT);
    }

    public static PublicKey getPublicKeyByFilePath(String pubFilePath, Charset charset) {
        return RsaUtil.getPublicKeyByFile(FileUtil.getFile((String[])new String[]{pubFilePath}), charset);
    }

    public static PublicKey getPublicKeyByFile(File pubFile) {
        return RsaUtil.getPublicKeyByFile(pubFile, CharsetUtil.DEFAULT);
    }

    public static PublicKey getPublicKeyByFile(File pubFile, Charset charset) {
        try {
            String publicKeyBase64 = FileUtil.readFileToString((File)pubFile, (Charset)charset);
            return RsaUtil.getPublicKeyByBase64(publicKeyBase64);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static Cipher getCipher(int mode, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(mode, key);
            return cipher;
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String encryptByPri(String data, String priKeyBase64) {
        return RsaUtil.encryptByPri(data, priKeyBase64, CharsetUtil.DEFAULT);
    }

    public static String encryptByPri(String data, String priKeyBase64, Charset charset) {
        PrivateKey privateKey = RsaUtil.getPrivateKeyByBase64(priKeyBase64);
        return RsaUtil.encrypt(data, privateKey, charset);
    }

    public static String encryptByPub(String data, String pubKeyBase64) {
        return RsaUtil.encryptByPub(data, pubKeyBase64, CharsetUtil.DEFAULT);
    }

    public static String encryptByPub(String data, String pubKeyBase64, Charset charset) {
        PublicKey publicKey = RsaUtil.getPublicKeyByBase64(pubKeyBase64);
        return RsaUtil.encrypt(data, publicKey, charset);
    }

    public static String encrypt(String data, Key key) {
        return RsaUtil.encrypt(data, key, CharsetUtil.DEFAULT);
    }

    public static String encrypt(String data, Key key, Charset charset) {
        try {
            Cipher cipherPrivate = RsaUtil.getCipher(1, key);
            byte[] bytes = cipherPrivate.doFinal(data.getBytes(charset));
            return CodecUtil.encodeBase64(bytes);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String decryptByPri(String cipherText, String priKeyBase64) {
        return RsaUtil.decryptByPri(cipherText, priKeyBase64, CharsetUtil.DEFAULT);
    }

    public static String decryptByPri(String cipherText, String priKeyBase64, Charset charset) {
        PrivateKey privateKey = RsaUtil.getPrivateKeyByBase64(priKeyBase64);
        return RsaUtil.decrypt(cipherText, privateKey, charset);
    }

    public static String decryptByPub(String cipherText, String pubKeyBase64) {
        return RsaUtil.decryptByPub(cipherText, pubKeyBase64, CharsetUtil.DEFAULT);
    }

    public static String decryptByPub(String cipherText, String pubKeyBase64, Charset charset) {
        PublicKey publicKey = RsaUtil.getPublicKeyByBase64(pubKeyBase64);
        return RsaUtil.decrypt(cipherText, publicKey, charset);
    }

    public static String decrypt(String cipherText, Key key) {
        return RsaUtil.decrypt(cipherText, key, CharsetUtil.DEFAULT);
    }

    public static String decrypt(String cipherText, Key key, Charset charset) {
        try {
            Cipher cipherPublic = RsaUtil.getCipher(2, key);
            byte[] decryptBytes = cipherPublic.doFinal(CodecUtil.decodeBase64(cipherText));
            return StringUtil.toEncodedString((byte[])decryptBytes, (Charset)charset);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String getSignatureForSha256(String privateKeyBase64, String data) {
        PrivateKey privateKey = RsaUtil.getPrivateKeyByBase64(privateKeyBase64);
        return RsaUtil.getSignatureForSha256(privateKey, data);
    }

    public static String getSignatureForSha256(PrivateKey privateKey, String data) {
        return RsaUtil.getSignature(SHA256_WITH_RSA, privateKey, data);
    }

    public static String getSignature(String algorithm, PrivateKey privateKey, String data) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(data.getBytes());
            byte[] sign = signature.sign();
            return CodecUtil.encodeHex(sign);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static boolean verifySignatureForSha256(String publicKeyBase64, String data, String signatureData) {
        PublicKey publicKey = RsaUtil.getPublicKeyByBase64(publicKeyBase64);
        return RsaUtil.verifySignatureForSha256(publicKey, data, signatureData);
    }

    public static boolean verifySignatureForSha256(PublicKey publicKey, String data, String signatureData) {
        return RsaUtil.verifySignature(SHA256_WITH_RSA, publicKey, data, signatureData);
    }

    public static boolean verifySignature(String algorithm, PublicKey publicKey, String data, String signatureData) {
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            signature.update(data.getBytes());
            return signature.verify(CodecUtil.decodeHex(signatureData));
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }
}

