/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.http;

import cn.net.wanmo.common.charset.CharsetUtil;
import cn.net.wanmo.common.pojo.HttpResult;
import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.IdGen;
import cn.net.wanmo.common.util.MapUtil;
import cn.net.wanmo.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpConnectionUtil.class);
    public static String METHOD_GET = "GET";
    public static String METHOD_POST = "POST";
    public static Integer connectTimeout = 3000;
    public static Integer readTimeout = 10000;

    public static HttpResult sendGet(String url) {
        return HttpConnectionUtil.sendGet(url, null, null);
    }

    public static HttpResult sendGet(String url, String param) {
        return HttpConnectionUtil.sendGet(url, param, null);
    }

    public static HttpResult sendGet(String url, Map<String, String> header) {
        return HttpConnectionUtil.sendGet(url, null, header);
    }

    public static HttpResult sendGet(String url, String param, Map<String, String> header) {
        return HttpConnectionUtil.requestAsString(url, METHOD_GET, param, header);
    }

    public static HttpResult sendPost(String url) {
        return HttpConnectionUtil.sendPost(url, null, null);
    }

    public static HttpResult sendPost(String url, String param) {
        return HttpConnectionUtil.sendPost(url, param, null);
    }

    public static HttpResult sendPost(String url, Map<String, String> header) {
        return HttpConnectionUtil.sendPost(url, null, header);
    }

    public static HttpResult sendPost(String url, String param, Map<String, String> header) {
        return HttpConnectionUtil.requestAsString(url, METHOD_POST, param, header);
    }

    public static HttpResult sendPostForJson(String url, String param) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json; charset=UTF-8");
        header.put("accept", "application/json");
        return HttpConnectionUtil.sendPost(url, param, header);
    }

    public static HttpResult sendPostAsFile(String url, String params) {
        return HttpConnectionUtil.requestAsFile(url, METHOD_POST, params, null);
    }

    public static HttpResult sendPostAsFile(String url, String params, Map<String, String> header) {
        return HttpConnectionUtil.requestAsFile(url, METHOD_POST, params, header);
    }

    public static HttpResult sendPostAsFileForJson(String url, String params) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json; charset=UTF-8");
        return HttpConnectionUtil.requestAsFile(url, METHOD_POST, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult requestAsFile(String url, String method, String params, Map<String, String> requestHeader) {
        HttpResult<String> result = new HttpResult<String>();
        HttpURLConnection conn = null;
        long startTime = DateUtil.nowLong();
        try {
            logger.debug("\u8bf7\u6c42URL: {}", (Object)url);
            logger.debug("\u8bf7\u6c42\u65b9\u5f0f: {}", (Object)method);
            logger.debug("\u8bf7\u6c42\u5934: {}", (Object)JSON.toJSONString(requestHeader));
            logger.debug("\u8bf7\u6c42\u6570\u636e: {}", (Object)params);
            conn = HttpConnectionUtil.getURLConnection(url, method, params, requestHeader);
            result.setCode(conn.getResponseCode());
            result.setMsg("Http\u8bf7\u6c42\u5b8c\u6210");
            InputStream is = conn.getInputStream();
            File file = HttpConnectionUtil.getStreamAsFile(is);
            result.setData(file.getAbsolutePath());
            logger.debug("\u54cd\u5e94\u6570\u636e: {}", result.getData());
        }
        catch (Exception e) {
            result.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff1a " + e.getMessage());
            logger.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff1a " + url, (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        result.setConsumeTime(Long.valueOf(DateUtil.nowLong() - startTime).intValue());
        logger.debug("\u54cd\u5e94\u7ed3\u679c\uff1a\u4ee3\u7801 {} \uff0c \u6d88\u606f {}", result.getCode(), (Object)result.getMsg());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult<String> requestAsString(String url, String method, String params, Map<String, String> requestHeader) {
        HttpResult<String> result = new HttpResult<String>();
        HttpURLConnection conn = null;
        try {
            logger.debug("\u8bf7\u6c42URL: {}", (Object)url);
            logger.debug("\u8bf7\u6c42\u65b9\u5f0f: {}", (Object)method);
            logger.debug("\u8bf7\u6c42\u5934: {}", (Object)JSON.toJSONString(requestHeader));
            logger.debug("\u8bf7\u6c42\u6570\u636e: {}", (Object)params);
            conn = HttpConnectionUtil.getURLConnection(url, method, params, requestHeader);
            result.setCode(conn.getResponseCode());
            result.setMsg("Http\u8bf7\u6c42\u5b8c\u6210");
            String charset = HttpConnectionUtil.getResponseCharset(conn.getContentType());
            String resBody = HttpConnectionUtil.getStreamAsString(conn.getInputStream(), charset);
            result.setData(resBody);
            logger.debug("\u54cd\u5e94\u6570\u636e: {}", result.getData());
        }
        catch (Exception e) {
            result.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff1a " + e.getMessage());
            logger.error("Http\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff1a " + url, (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        logger.debug("\u54cd\u5e94\u7ed3\u679c\uff1a\u4ee3\u7801 {} \uff0c \u6d88\u606f {}", result.getCode(), (Object)result.getMsg());
        return result;
    }

    private static String getResponseCharset(String ctype) {
        String[] params;
        String charset = null;
        if (StringUtil.isBlank((CharSequence)ctype)) {
            charset = CharsetUtil.UTF8_NAME;
            return charset;
        }
        for (String param : params = ctype.split(";")) {
            if (!(param = param.trim()).startsWith("charset")) continue;
            String[] pair = param.split("=", 2);
            if (pair.length != 2 || StringUtil.isEmpty((CharSequence)pair[1])) break;
            charset = pair[1].trim();
            break;
        }
        return charset;
    }

    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        return HttpConnectionUtil.getStreamAsString_1(stream, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString_1(InputStream stream, String charset) throws IOException {
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            Scanner scanner = new Scanner(stream, charset);
            StringBuffer buffer = new StringBuffer();
            while (scanner.hasNextLine()) {
                buffer.append(scanner.nextLine());
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString_2(InputStream stream, String charset) throws IOException {
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, charset));
            StringBuffer buffer = new StringBuffer();
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString_3(InputStream stream, String charset) throws IOException {
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[1024];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static File getStreamAsFile(InputStream stream) throws IOException {
        return HttpConnectionUtil.getStreamAsFile_1(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getStreamAsFile_1(InputStream stream) throws IOException {
        try {
            int len;
            if (stream == null) {
                File file = null;
                return file;
            }
            File file = File.createTempFile(IdGen.uuid(), "tmp");
            BufferedInputStream bis = new BufferedInputStream(stream);
            FileOutputStream os = new FileOutputStream(file);
            byte[] arr = new byte[1024];
            while ((len = bis.read(arr)) != -1) {
                ((OutputStream)os).write(arr, 0, len);
                os.flush();
            }
            ((OutputStream)os).close();
            bis.close();
            File file2 = file;
            return file2;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static HttpURLConnection getURLConnection(String httpUrl) throws Exception {
        return HttpConnectionUtil.getURLConnection(httpUrl, METHOD_GET, null, null);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method) throws Exception {
        return HttpConnectionUtil.getURLConnection(httpUrl, method, null, null);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, String params) throws Exception {
        return HttpConnectionUtil.getURLConnection(httpUrl, method, params, null);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, Map<String, String> requestHeader) throws Exception {
        return HttpConnectionUtil.getURLConnection(httpUrl, method, null, requestHeader);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, String params, Map<String, String> requestHeader) throws Exception {
        return HttpConnectionUtil.getURLConnection(httpUrl, method, params, requestHeader, connectTimeout, readTimeout);
    }

    public static HttpURLConnection getURLConnection(String httpUrl, String method, String params, Map<String, String> requestHeader, Integer connectTimeout, Integer readTimeout) throws Exception {
        if (StringUtil.equalsIgnoreCase((CharSequence)METHOD_GET, (CharSequence)method) && StringUtil.isNotBlank((CharSequence)params)) {
            httpUrl = httpUrl + "?" + params;
        }
        URL url = new URL(httpUrl);
        HttpURLConnection conn = null;
        if ("HTTPS".equals(url.getProtocol().toUpperCase())) {
            HttpsURLConnection connectionHttps = (HttpsURLConnection)url.openConnection();
            connectionHttps.setSSLSocketFactory(HttpConnectionUtil.getSSLSocket());
            conn = connectionHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setRequestProperty("connection", "Keep-Alive");
        conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        if (MapUtil.isNotEmpty(requestHeader)) {
            for (Map.Entry entry : requestHeader.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        conn.setRequestMethod(method);
        if (StringUtil.equalsIgnoreCase((CharSequence)METHOD_GET, (CharSequence)method)) {
            conn.setUseCaches(true);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)METHOD_POST, (CharSequence)method)) {
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            if (StringUtil.isNotBlank((CharSequence)params)) {
                PrintWriter out = new PrintWriter(conn.getOutputStream());
                out.print(params);
                out.flush();
                out.close();
            }
        }
        conn.connect();
        return conn;
    }

    private static SSLSocketFactory getSSLSocket() throws NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
        sslContext.init(null, tm, new SecureRandom());
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        return ssf;
    }

    public static String toParamStr(Map<String, String> param) throws UnsupportedEncodingException {
        String reStr = "";
        if (MapUtil.isEmpty(param)) {
            return reStr;
        }
        Set<Map.Entry<String, String>> entrySet = param.entrySet();
        for (Map.Entry<String, String> o : entrySet) {
            if (o.getValue() == null || "null".equals(o.getValue()) || "class".equals(o.getKey())) continue;
            String s = o.getKey() + "=" + o.getValue();
            reStr = reStr + s + "&";
        }
        return StringUtil.isBlank((CharSequence)reStr) ? "" : reStr.substring(0, reStr.length() - 1);
    }

    public static Map<String, String> toParamMap(String param) throws UnsupportedEncodingException {
        String[] paramPairsArr;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StringUtil.isBlank((CharSequence)param)) {
            return paramMap;
        }
        for (String paramPair : paramPairsArr = param.split("&")) {
            String[] paramPairArr = paramPair.split("=");
            if (paramPairArr.length == 2) {
                paramMap.put(paramPairArr[0].trim(), paramPairArr[1].trim());
                continue;
            }
            paramMap.put(paramPairArr[0].trim(), "");
        }
        return paramMap;
    }

    public static Boolean isHttpUrl(String url) {
        boolean flag = false;
        try {
            flag = url.indexOf("://") != -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }
}

