/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.minio;

import cn.net.wanmo.common.minio.MinioConfig;
import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.Exceptions;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.RemoveBucketArgs;
import io.minio.messages.Bucket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketUtil {
    private static Logger logger = LoggerFactory.getLogger(BucketUtil.class);

    public static boolean bucketExists(String bucketName) {
        try {
            return MinioConfig.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u5b58\u50a8\u6876\u662f\u5426\u5b58\u5728 \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static boolean makeBucket(String bucketName) {
        try {
            boolean flag = BucketUtil.bucketExists(bucketName);
            if (BooleanUtil.isFalse((Boolean)flag)) {
                MinioConfig.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
            logger.debug("Bucket '{}' is successfully created.", (Object)bucketName);
            return true;
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5b58\u50a8\u6876 \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static List<Bucket> listBuckets() {
        try {
            return MinioConfig.client.listBuckets();
        }
        catch (Exception e) {
            logger.error("\u5217\u51fa\u6240\u6709\u5b58\u50a8\u6876 \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static List<String> listBucketNames() {
        ArrayList<String> bucketListNames = new ArrayList<String>();
        List<Bucket> buckets = BucketUtil.listBuckets();
        for (Bucket bucket : buckets) {
            bucketListNames.add(bucket.name());
        }
        return bucketListNames;
    }

    public static void removeBucket(String bucketName) {
        try {
            MinioConfig.client.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            logger.error("\u79fb\u9664\u5b58\u50a8\u6876 \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }
}

