/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.minio;

import cn.net.wanmo.common.minio.BucketUtil;
import cn.net.wanmo.common.minio.MinioConfig;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.UploadObjectArgs;
import io.minio.http.Method;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil {
    private static Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    public static void uploadObject(String bucketName, String saveFilename, String localFilepath) {
        try {
            BucketUtil.makeBucket(bucketName);
            MinioConfig.client.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(saveFilename)).filename(localFilepath).build());
            logger.debug("'{}' is successfully uploaded as object '{}' to bucket '{}'.", new Object[]{localFilepath, saveFilename, bucketName});
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20 MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static void putObject(String bucketName, String saveFilename, InputStream is) {
        ObjectUtil.putObject(bucketName, saveFilename, is, null);
    }

    public static void putObject(String bucketName, String saveFilename, InputStream is, String contentType) {
        try {
            BucketUtil.makeBucket(bucketName);
            MinioConfig.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().contentType(StringUtil.isBlank((CharSequence)contentType) ? null : contentType).bucket(bucketName)).object(saveFilename)).stream(is, (long)is.available(), -1L).build());
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20 MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static InputStream getObject(String bucketName, String downloadFilename) {
        GetObjectResponse stream;
        try {
            stream = MinioConfig.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(downloadFilename)).build());
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
        return stream;
    }

    public static InputStream getObject(String bucketName, String downloadFilename, Long offset, Long length) {
        GetObjectResponse stream;
        try {
            stream = MinioConfig.client.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(downloadFilename)).offset(offset)).length(length)).build());
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
        return stream;
    }

    public static void downloadObject(String bucketName, String downloadFilename, String localFilepath) {
        try {
            MinioConfig.client.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(downloadFilename)).filename(localFilepath).build());
            logger.debug("'{}' is successfully downloaded as object '{}' from bucket '{}'.", new Object[]{localFilepath, downloadFilename, bucketName});
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static void removeObject(String bucketName, String removeFilename) {
        try {
            MinioConfig.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(removeFilename)).build());
            logger.debug("successfully removed as object '{}' from bucket '{}'.", (Object)removeFilename, (Object)bucketName);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u79fb\u9664 MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static void removeObjects(String bucketName, List<String> removeFilenames) {
        try {
            LinkedList<DeleteObject> objects = new LinkedList<DeleteObject>();
            for (String objectName : removeFilenames) {
                objects.add(new DeleteObject(objectName));
            }
            Iterable results = MinioConfig.client.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects(objects).build());
            for (Result result : results) {
                DeleteError error = (DeleteError)result.get();
                logger.error("Error in deleting object {} , errMsg {}", (Object)error.objectName(), (Object)error.message());
            }
            logger.debug("successfully removed as objects '{}' from bucket '{}'.", removeFilenames, (Object)bucketName);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u79fb\u9664 MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static String presignedGetObjectUrl(String bucketName, String fileName, String contentType) {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("response-content-type", contentType == null ? "application/pdf" : contentType);
            return MinioConfig.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(fileName)).expiry(7, TimeUnit.DAYS).extraQueryParams(queryParams)).build());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u9884\u7b7e\u540dURL MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }

    public static String presignedPostObjectUrl(String bucketName, String fileName, String contentType) {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("response-content-type", contentType == null ? "application/pdf" : contentType);
            return MinioConfig.client.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.POST).bucket(bucketName)).object(fileName)).expiry(7, TimeUnit.DAYS).extraQueryParams(queryParams)).build());
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u9884\u7b7e\u540dURL MinIO \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw Exceptions.unchecked(e);
        }
    }
}

