/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.pojo;

import com.alibaba.fastjson.JSON;

public abstract class DefaultResult<Code, Data> {
    protected Code code;
    protected String msg;
    protected Data data;
    protected Integer consumeTime;

    public DefaultResult success(String msg, Data data) {
        this.setCode(this.getDefaultSuccessCode());
        this.setMsg(msg);
        this.setData(data);
        return this;
    }

    public DefaultResult success(String msg) {
        return this.success(msg, null);
    }

    public DefaultResult success(Data data) {
        return this.success(this.getDefaultSuccessMsg(), data);
    }

    public DefaultResult success() {
        return this.success(this.getDefaultSuccessMsg(), null);
    }

    public DefaultResult error(String msg, Data data) {
        this.setCode(this.getDefaultErrorCode());
        this.setMsg(msg);
        this.setData(data);
        return this;
    }

    public DefaultResult error(String msg) {
        return this.error(msg, null);
    }

    public DefaultResult error() {
        return this.error(this.getDefaultErrorMsg(), null);
    }

    public DefaultResult fail(Code code, String msg) {
        this.setCode(code);
        this.setMsg(msg);
        return this;
    }

    public DefaultResult fail(Code code, String msg, Data data) {
        this.fail(code, msg);
        this.setData(data);
        return this;
    }

    public String tip() {
        return String.format("\u5185\u5bb9\uff1a\u3010%s\u3011\uff0c\u4ee3\u7801\uff1a\u3010%s\u3011\uff0c\u6570\u636e\uff1a\u3010%s\u3011\uff0c\u662f\u5426\u6210\u529f\uff1a\u3010%b\u3011", this.getMsg(), this.getCode(), JSON.toJSON(this.getData()), this.isSuccess());
    }

    public String toJSONString() {
        return JSON.toJSONString((Object)this);
    }

    abstract Code getDefaultSuccessCode();

    abstract String getDefaultSuccessMsg();

    abstract Code getDefaultErrorCode();

    abstract String getDefaultErrorMsg();

    public abstract boolean isSuccess();

    public DefaultResult() {
    }

    public DefaultResult(Code code, String msg, Data data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public Integer getConsumeTime() {
        return this.consumeTime;
    }

    public void setConsumeTime(Integer consumeTime) {
        this.consumeTime = consumeTime;
    }
}

