/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.restful;

import cn.net.wanmo.common.http.HttpConnectionUtil;
import cn.net.wanmo.common.pojo.HttpResult;
import cn.net.wanmo.common.pojo.InterfaceResult;
import cn.net.wanmo.common.restful.SendWay;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.util.DateUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;

public class SendUtil {
    public static <RequestObj extends Req, ResponseObj extends Res> InterfaceResult<ResponseObj> sendGet(String msgPre, String url, RequestObj requestObj, ResponseObj responseObj, Logger logger) {
        return SendUtil.sendExec(msgPre, url, requestObj, responseObj, logger, SendWay.GET);
    }

    public static <RequestObj extends Req, ResponseObj extends Res> InterfaceResult<ResponseObj> sendPost(String msgPre, String url, RequestObj requestObj, ResponseObj responseObj, Logger logger) {
        return SendUtil.sendExec(msgPre, url, requestObj, responseObj, logger, SendWay.POST);
    }

    public static <RequestObj extends Req, ResponseObj extends Res> InterfaceResult<ResponseObj> sendPostForJson(String msgPre, String url, RequestObj requestObj, ResponseObj responseObj, Logger logger) {
        return SendUtil.sendExec(msgPre, url, requestObj, responseObj, logger, SendWay.POST_JSON);
    }

    public static <RequestObj extends Req, ResponseObj extends Res> InterfaceResult<ResponseObj> sendExec(String msgPre, String url, RequestObj requestObj, ResponseObj responseObj, Logger logger, SendWay sendWay) {
        InterfaceResult<ResponseObj> result = new InterfaceResult<ResponseObj>();
        try {
            HttpResult httpResult = null;
            logger.info(msgPre + "\u8bf7\u6c42\u4f53\uff1a{}", (Object)requestObj.toString());
            switch (sendWay) {
                case GET: {
                    httpResult = HttpConnectionUtil.sendGet(url, requestObj.toString());
                    break;
                }
                case POST: {
                    httpResult = HttpConnectionUtil.sendPost(url, requestObj.toString());
                    break;
                }
                case POST_JSON: {
                    httpResult = HttpConnectionUtil.sendPostForJson(url, requestObj.toString());
                    break;
                }
                default: {
                    httpResult = new HttpResult();
                    httpResult.error("\u8be5 HTTP \u8bf7\u6c42\u65b9\u5f0f\u4e0d\u652f\u6301");
                }
            }
            logger.info(msgPre + "\u54cd\u5e94\u4f53\uff1a{}", httpResult.getData());
            if (httpResult.isSuccess()) {
                Object data = httpResult.getData();
                responseObj.parse(JSON.parseObject((String)String.valueOf(data)));
                responseObj.setConsumeTime(Long.valueOf(DateUtil.nowLong() - requestObj.getStartTime()).intValue());
                if (responseObj.isSuccess()) {
                    result.success(msgPre + responseObj.getErrMsg(), responseObj);
                    result.setConsumeTime(responseObj.getConsumeTime());
                    logger.info(result.toJSONString());
                } else {
                    result.fail(responseObj.getErrCode(), msgPre + responseObj.getErrMsg(), responseObj);
                    result.setConsumeTime(responseObj.getConsumeTime());
                    logger.warn(result.toJSONString());
                }
            } else {
                responseObj.setErrCode(String.valueOf(httpResult.getCode()));
                responseObj.setErrMsg(httpResult.getMsg());
                responseObj.setConsumeTime(Long.valueOf(DateUtil.nowLong() - requestObj.getStartTime()).intValue());
                result.error(String.format("%s\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1aHTTP\u72b6\u6001\u7801 \uff08%d\uff09\uff0cHTTP\u9519\u8bef\u6d88\u606f \uff08%s\uff09", msgPre, httpResult.getCode(), httpResult.getMsg()), responseObj);
                result.setConsumeTime(responseObj.getConsumeTime());
                logger.error(result.toJSONString());
            }
        }
        catch (Exception e) {
            responseObj.setErrCode("exception");
            responseObj.setErrMsg(e.getMessage());
            responseObj.setConsumeTime(Long.valueOf(DateUtil.nowLong() - requestObj.getStartTime()).intValue());
            result.error(msgPre + "\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), responseObj);
            result.setConsumeTime(responseObj.getConsumeTime());
            logger.error(result.getMsg(), (Throwable)e);
        }
        return result;
    }
}

