/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import cn.net.wanmo.common.util.Exceptions;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    public static String YYYY = "yyyy";
    public static String YYYY_MM = "yyyy-MM";
    public static String YYYY_MM_DD = "yyyy-MM-dd";
    public static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyy-MM-dd HH:mm:ss.s", "yyyy-MM-dd HH:mm:ss.ss", "yyyy-MM-dd HH:mm:ss.sss"};

    public static Calendar nowCalendar() {
        return Calendar.getInstance();
    }

    public static Date nowDate() {
        return DateUtil.nowCalendar().getTime();
    }

    public static long nowLong() {
        return DateUtil.nowDate().getTime();
    }

    public static Date addMilliseconds(int millisecond) {
        return DateUtil.addMilliseconds(DateUtil.nowDate(), millisecond);
    }

    public static Date addMilliseconds(Date date, int millisecond) {
        return DateUtil.add(date, 14, millisecond);
    }

    public static Date addSeconds(int second) {
        return DateUtil.addSeconds(DateUtil.nowDate(), second);
    }

    public static Date addSeconds(Date date, int second) {
        return DateUtil.add(date, 13, second);
    }

    public static Date addMinutes(int minute) {
        return DateUtil.addMinutes(DateUtil.nowDate(), minute);
    }

    public static Date addMinutes(Date date, int minute) {
        return DateUtil.add(date, 12, minute);
    }

    public static Date addHours(int hour) {
        return DateUtil.addHours(DateUtil.nowDate(), hour);
    }

    public static Date addHours(Date date, int hour) {
        return DateUtil.add(date, 11, hour);
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date getDateBefore(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(5, DateUtil.nowCalendar().get(5) - day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date getDateAfter(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(5, DateUtil.nowCalendar().get(5) + day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date getDateBeforeMinute(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(12, DateUtil.nowCalendar().get(12) - day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date getDateAfterMinute(Date date, int day) {
        DateUtil.nowCalendar().setTime(date);
        DateUtil.nowCalendar().set(12, DateUtil.nowCalendar().get(12) + day);
        return DateUtil.nowCalendar().getTime();
    }

    public static Date parse(String source) {
        if (source == null) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)source, (String[])parsePatterns);
        }
        catch (ParseException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String format(Date date, String ... pattern) {
        if (date == null) {
            return null;
        }
        if (pattern == null || pattern.length == 0) {
            return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        }
        return DateFormatUtils.format((Date)date, (String)pattern[0]);
    }

    public static String formatUTC(Date date, String pattern) {
        return DateFormatUtils.formatUTC((Date)date, (String)pattern);
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtil.format(date, pattern);
    }

    public static String formatDay() {
        return DateUtil.formatDay(DateUtil.nowDate());
    }

    public static String formatDay(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd");
    }

    public static String formatDayTime() {
        return DateUtil.formatDayTime(DateUtil.nowDate());
    }

    public static String formatDayTime(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getYear() {
        return DateUtil.format(DateUtil.nowDate(), "yyyy");
    }

    public static String getMonth() {
        return DateUtil.format(DateUtil.nowDate(), "MM");
    }

    public static String getDay() {
        return DateUtil.format(DateUtil.nowDate(), "dd");
    }

    public static String getHour() {
        return DateUtil.format(DateUtil.nowDate(), "HH");
    }

    public static String getWeek() {
        return DateUtil.format(DateUtil.nowDate(), "E");
    }

    public static long pastDays(Date date) {
        long t = DateUtil.nowLong() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = DateUtil.nowLong() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = DateUtil.nowLong() - date.getTime();
        return t / 60000L;
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        return Math.abs((int)((date2.getTime() - date1.getTime()) / 86400000L));
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }
}

