/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    private static final char SEPARATOR = '_';

    public static String toString(Object obj, String defaultVal) {
        return Objects.toString(obj, defaultVal);
    }

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean inString(String str, String ... strs) {
        if (StringUtil.isBlank((CharSequence)str) || strs == null) {
            return false;
        }
        List<String> list = Arrays.asList(strs);
        return list.contains(str);
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtil.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence ... searchCharSequences) {
        if (StringUtil.isEmpty((CharSequence)cs) || searchCharSequences == null || searchCharSequences.length == 0) {
            return false;
        }
        for (CharSequence testStr : searchCharSequences) {
            if (!StringUtil.containsIgnoreCase((CharSequence)cs, (CharSequence)testStr)) continue;
            return true;
        }
        return false;
    }

    public static String preZeros(int num, int length) {
        String s = String.valueOf(num);
        int differ = length - s.length();
        if (differ > 0) {
            for (int i = 0; i <= differ - 1; ++i) {
                s = "0" + s;
            }
        }
        return s;
    }

    public static String getRandomCode(int length) {
        String[] arr = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        String str = "";
        for (int i = 0; i < length; ++i) {
            int r = (int)(Math.random() * 61.0);
            str = str + arr[r];
        }
        return str;
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return "";
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return "";
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return "";
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static boolean isHttp(String link) {
        return StringUtils.startsWithAny((CharSequence)link, (CharSequence[])new CharSequence[]{"http://", "https://"});
    }

    public static final Set<String> str2Set(String str, String sep) {
        return new HashSet<String>(StringUtil.str2List(str, sep, true, false));
    }

    public static final List<String> str2List(String str, String sep, boolean filterBlank, boolean trim) {
        String[] split;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)str)) {
            return list;
        }
        if (filterBlank && StringUtils.isBlank((CharSequence)str)) {
            return list;
        }
        for (String string : split = str.split(sep)) {
            if (filterBlank && StringUtils.isBlank((CharSequence)string)) continue;
            if (trim) {
                string = string.trim();
            }
            list.add(string);
        }
        return list;
    }

    public static String toUnderScoreCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean preCharIsUpperCase = true;
        boolean curreCharIsUpperCase = true;
        boolean nexteCharIsUpperCase = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            preCharIsUpperCase = i > 0 ? Character.isUpperCase(str.charAt(i - 1)) : false;
            curreCharIsUpperCase = Character.isUpperCase(c);
            if (i < str.length() - 1) {
                nexteCharIsUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (preCharIsUpperCase && curreCharIsUpperCase && !nexteCharIsUpperCase) {
                sb.append('_');
            } else if (i != 0 && !preCharIsUpperCase && curreCharIsUpperCase) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String padl(Number num, int size) {
        return StringUtil.padl(num.toString(), size, '0');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String padl(String s, int size, char c) {
        StringBuilder sb = new StringBuilder(size);
        if (s != null) {
            int len = s.length();
            if (s.length() > size) return s.substring(len - size, len);
            for (int i = size - len; i > 0; --i) {
                sb.append(c);
            }
            sb.append(s);
            return sb.toString();
        } else {
            for (int i = size; i > 0; --i) {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String phoneEncrypt(String s) {
        if (StringUtil.isNotBlank((CharSequence)s) && s.length() == 11) {
            String prefix = s.substring(0, 3);
            String suffix = s.substring(s.length() - 4);
            return prefix + "****" + suffix;
        }
        return "";
    }

    public static String idcardEncrypt(String s) {
        if (StringUtil.isNotBlank((CharSequence)s) && s.length() == 18) {
            String prefix = s.substring(0, 6);
            String suffix = s.substring(s.length() - 4);
            return prefix + "********" + suffix;
        }
        return "";
    }
}

