/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.windows;

import cn.net.wanmo.common.util.Exceptions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdExecUtil {
    private static Logger logger = LoggerFactory.getLogger(CmdExecUtil.class);

    public static R execCommand(String command) {
        return CmdExecUtil.execCommand(command, false);
    }

    public static R execCommand(String command, boolean isWait) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            return CmdExecUtil.getProcessR(process, isWait);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static R execCommand(String[] commands) {
        return CmdExecUtil.execCommand(commands, false);
    }

    public static R execCommand(String[] commands, boolean isWait) {
        try {
            Process process = Runtime.getRuntime().exec(commands);
            return CmdExecUtil.getProcessR(process, isWait);
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static R getProcessR(Process process, boolean isWait) {
        try {
            R r = new R();
            r.setInputStr(CmdExecUtil.getStreamStr(process.getInputStream()));
            r.setErrorStr(CmdExecUtil.getStreamStr(process.getErrorStream()));
            if (isWait) {
                int waitFor = process.waitFor();
                r.setWaitFor(waitFor);
            }
            process.destroy();
            return r;
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String getStreamStr(InputStream is) {
        return CmdExecUtil.getStreamStr(is, "GBK");
    }

    public static String getStreamStr(InputStream is, String charsetName) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, charsetName));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
        finally {
            try {
                is.close();
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    static class R {
        private int waitFor;
        private String inputStr;
        private String errorStr;

        public R() {
        }

        public R(int waitFor, String inputStr, String errorStr) {
            this.waitFor = waitFor;
            this.inputStr = inputStr;
            this.errorStr = errorStr;
        }

        public int getWaitFor() {
            return this.waitFor;
        }

        public void setWaitFor(int waitFor) {
            this.waitFor = waitFor;
        }

        public String getInputStr() {
            return this.inputStr;
        }

        public void setInputStr(String inputStr) {
            this.inputStr = inputStr;
        }

        public String getErrorStr() {
            return this.errorStr;
        }

        public void setErrorStr(String errorStr) {
            this.errorStr = errorStr;
        }
    }
}

