package cn.net.wanmo.common.pojo;

import cn.net.wanmo.common.util.StringUtil;
import com.alibaba.fastjson.JSON;

public abstract class DefaultResult<Code, Data> {

    public DefaultResult success(String msg, Data data) {
        setCode(getDefaultSuccessCode());
        setMsg(msg);
        setData(data);
        return this;
    }

    public DefaultResult success(String msg) {
        return success(msg, null);
    }

    public DefaultResult success(Data data) {
        return success(getDefaultSuccessMsg(), data);
    }

    public DefaultResult success() {
        return success(getDefaultSuccessMsg(), null);
    }

    public DefaultResult error(String msg, Data data) {
        setCode(getDefaultErrorCode());
        setMsg(msg);
        setData(data);
        return this;
    }

    public DefaultResult error(String msg) {
        return error(msg, null);
    }

    public DefaultResult error() {
        return error(getDefaultErrorMsg(), null);
    }

    public DefaultResult fail(Code code, String msg) {
        setCode(code);
        setMsg(msg);
        return this;
    }

    public DefaultResult fail(Code code, String msg, Data data) {
        fail(code, msg);
        setData(data);
        return this;
    }

    public String tip() {
        return String.format("内容：【%s】，代码：【%s】，数据：【%s】，是否成功：【%b】", getMsg(), getCode(), JSON.toJSON(getData()), isSuccess());
    }

    public String toJSONString() {
        return JSON.toJSONString(this);
    }


    abstract Code getDefaultSuccessCode();

    abstract String getDefaultSuccessMsg();

    abstract Code getDefaultErrorCode();

    abstract String getDefaultErrorMsg();

    public abstract boolean isSuccess();

    protected Code code; // 编码
    protected String msg; // 内容
    protected Data data; // 数据
    protected Integer consumeTime; // 耗时

    public DefaultResult() {
    }

    public DefaultResult(Code code, String msg, Data data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Code getCode() {
        return code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public Integer getConsumeTime() {
        return consumeTime;
    }

    public void setConsumeTime(Integer consumeTime) {
        this.consumeTime = consumeTime;
    }
}
