package cn.net.wanmo.common.pojo;

import cn.net.wanmo.common.constant.HttpStatus;

public class HttpResult<Data> extends DefaultResult<Integer, Data> {


    @Override
    Integer getDefaultSuccessCode() {
        return HttpStatus.SUCCESS;
    }

    @Override
    String getDefaultSuccessMsg() {
        return "操作成功";
    }

    @Override
    Integer getDefaultErrorCode() {
        return HttpStatus.ERROR;
    }

    @Override
    String getDefaultErrorMsg() {
        return "操作失败";
    }

    @Override
    public boolean isSuccess() {
        int defaultSuccessCode = getDefaultSuccessCode();
        int code = getCode();

        return defaultSuccessCode == code;
    }

}
