/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.pojo;

import cn.net.wanmo.common.util.ObjectUtil;
import cn.net.wanmo.common.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class WanMoResult<T>
extends JSONObject {
    protected static final long serialVersionUID = 1L;
    public static final String CODE_TAG = "code";
    public static final String MSG_TAG = "msg";
    public static final String DESC_TAG = "desc";
    public static final String DATA_TAG = "data";
    public static final String CONSUME_TIME_TAG = "consumeTime";
    public static String DEFAULT_SUCCESS_CODE = "success";
    public static String DEFAULT_SUCCESS_MSG = "\u64cd\u4f5c\u6210\u529f";
    public static String DEFAULT_ERROR_CODE = "error";
    public static String DEFAULT_ERROR_MSG = "\u64cd\u4f5c\u5931\u8d25";

    public WanMoResult() {
    }

    public WanMoResult(String code, String msg) {
        super.put(CODE_TAG, (Object)code);
        super.put(MSG_TAG, (Object)msg);
    }

    public WanMoResult(String code, String msg, T data) {
        this(code, msg);
        super.put(DATA_TAG, data);
    }

    public static WanMoResult success() {
        return WanMoResult.success(DEFAULT_SUCCESS_MSG);
    }

    public static WanMoResult success(String msg) {
        return new WanMoResult<Object>(DEFAULT_SUCCESS_CODE, msg, null);
    }

    public static <T> WanMoResult success(T data) {
        return WanMoResult.success(DEFAULT_SUCCESS_MSG, data);
    }

    public static <T> WanMoResult success(String msg, T data) {
        return new WanMoResult<T>(DEFAULT_SUCCESS_CODE, msg, data);
    }

    public boolean isSuccess() {
        return StringUtil.equals((CharSequence)DEFAULT_SUCCESS_CODE, (CharSequence)this.getCode());
    }

    public static WanMoResult error() {
        return WanMoResult.error(DEFAULT_ERROR_MSG);
    }

    public static WanMoResult error(String msg) {
        return new WanMoResult<Object>(DEFAULT_ERROR_CODE, msg, null);
    }

    public static <T> WanMoResult error(String msg, T data) {
        return new WanMoResult<T>(DEFAULT_ERROR_CODE, msg, data);
    }

    public static WanMoResult fail(String code, String msg) {
        return new WanMoResult<Object>(code, msg, null);
    }

    public WanMoResult put(String key, Object value) {
        super.put(key, value);
        return this;
    }

    public WanMoResult setCode(String code) {
        return this.put(CODE_TAG, (Object)code);
    }

    public String getCode() {
        return this.getString(CODE_TAG);
    }

    public WanMoResult setMsg(String msg) {
        return this.put(MSG_TAG, (Object)msg);
    }

    public String getMsg() {
        return this.getString(MSG_TAG);
    }

    public WanMoResult setDesc(String desc) {
        return this.put(DESC_TAG, (Object)desc);
    }

    public String getDesc() {
        return this.getString(DESC_TAG);
    }

    public WanMoResult setConsumeTime(Integer consumeTime) {
        return this.put(CONSUME_TIME_TAG, (Object)consumeTime);
    }

    public Integer getConsumeTime() {
        return this.getInteger(CONSUME_TIME_TAG);
    }

    public WanMoResult setData(T data) {
        return this.put(DATA_TAG, data);
    }

    public T getData() {
        return ObjectUtil.cast(this.get(DATA_TAG));
    }

    public String getTip() {
        return String.format("\u5185\u5bb9\uff1a\u3010%s\u3011\uff0c\u4ee3\u7801\uff1a\u3010%s\u3011\uff0c\u6570\u636e\uff1a\u3010%s\u3011\uff0c\u662f\u5426\u6210\u529f\uff1a\u3010%b\u3011", this.getMsg(), this.getCode(), JSON.toJSON(this.getData()), this.isSuccess());
    }
}

