package cn.net.wanmo.module.sys.dao;

import java.util.List;

import cn.net.wanmo.base.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.mybatis.annotation.MyBatisDao;

/**
 * 系统用户 DAO
 */
@MyBatisDao
public interface UserDao extends BaseDao<User> {

    /**
     * 根据登录名查找用户
     *
     * @param loginName 登录名
     * @return 用户
     */
    User getByLoginName(@Param("loginName") String loginName);

    /**
     * 删除用户与角色关系
     *
     * @param userId 用户主键
     * @return 影响行数
     */
    int deleteUserRole(@Param("userId") String userId);

    /**
     * 插入用户与角色关系
     *
     * @param userId   用户主键
     * @param roleList 角色集合
     * @return 影响行数
     */
    int insertUserRole(@Param("userId") String userId, @Param("roleList") List<Role> roleList);

}
