package cn.net.wanmo.module.sys.entity;

import java.io.File;

import cn.net.wanmo.base.entity.MyBaseEntity;
import cn.net.wanmo.module.sys.util.AnnexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;

import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.FileUtil;

/**
 * 附件 Entity
 */
public class Annex extends MyBaseEntity<Annex> {
    private static final long serialVersionUID = 1L;
    private String fileName; // 表单提交的文件名称
    private String filePath; // 保存的附件的相对路径
    private String originalFilename; // 原始文件名称
    private String contentType; // 文件类型
    private Long fileSize; // 文件大小
    private String fileType; // 暂未使用
    private String relationId; // 关联数据 ID

    public Annex() {
        super();
    }

    public Annex(String id) {
        super(id);
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonIgnore
    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getOriginalFilename() {
        return originalFilename;
    }

    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    @JsonIgnore
    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    /**
     * 物理文件存在
     */
    public Boolean getFileExist() {
        Boolean flag = false;
        try {
            File file = getFile();
            flag = (file.isFile() && file.exists());
        } catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    /**
     * 物理文件不存在
     */
    public Boolean getFileNotExist() {
        return BooleanUtil.isFalse(getFileExist());
    }

    /**
     * 获取附件对应的真实文件
     */
    @JsonIgnore
    public File getFile() {
        return new File(AnnexUtil.getUploadBaseDir() + filePath);
    }

    /**
     * 获取带点的后缀，小写
     */
    public String getDotSuffix() {
        return FileUtil.getFileSuffix(originalFilename);
    }

    /**
     * 获取存储在磁盘上的文件名称
     */
    public String getPhysicalName() {
        return getId() + getDotSuffix();
    }

}
