package cn.net.wanmo.module.sys.entity;


import cn.net.wanmo.base.entity.MyBaseTreeEntity;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.util.DictUtil;
import cn.net.wanmo.module.sys.util.SysDictType;

/**
 * 区域 Entity
 */
public class Area extends MyBaseTreeEntity<Area> {
    private static final long serialVersionUID = 1L;
    public static String ROOT_ID = "1";

    private Integer code; // 区域编码
    private String name; // 区域名称
    private Dict type; // 区域类型（1：国家；2：省份、直辖市；3：地市；4：区县）

    public Area() {
        super();
    }

    public Area(String id) {
        super(id);
    }

    public Area(Area parent) {
        super();
        this.parent = parent;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Dict getType() {
        type = DictUtil.fitProperty(type, SysDictType.AREA_TYPE);
        return type;
    }

    public void setType(Dict type) {
        this.type = type;
    }

    @Override
    public String getDefaultOrderBy() {
        return " a.code ";
    }

    @Override
    public String getRootId() {
        return ROOT_ID;
    }

    // Mapper 支持开始
    private String typeValue; // 区域类型值

    public void setTypeValue(String typeValue) {
        this.typeValue = typeValue;
        setType(new Dict(null, typeValue));
    }
    // Mapper 支持结束
}
