package cn.net.wanmo.module.sys.entity;

import java.util.List;

import cn.net.wanmo.base.entity.MyBaseEntity;
import cn.net.wanmo.module.sys.enums.dict.EnableOrForbid;
import com.google.common.collect.Lists;

import cn.net.wanmo.module.sys.util.DictUtil;
import cn.net.wanmo.module.sys.util.SysDictType;

/**
 * 角色 Entity
 */
public class Role extends MyBaseEntity<Role> {
	private static final long serialVersionUID = 1L;

	private String ename; // 英文名称
	private String cname; // 中文名称
	private Dict useable; // 是否可用

	private List<Menu> menus; // 关联的菜单数据

	public Role() {
		super();
		this.menus = Lists.newArrayList();
	}

	public Role(String id) {
		super(id);
	}

	public String getEname() {
		return ename;
	}

	public void setEname(String ename) {
		this.ename = ename;
	}

	public String getCname() {
		return cname;
	}

	public void setCname(String cname) {
		this.cname = cname;
	}

	public Dict getUseable() {
		useable = DictUtil.fitProperty(useable, EnableOrForbid.type);
		return useable;
	}

	public void setUseable(Dict useable) {
		this.useable = useable;
	}

	public List<Menu> getMenus() {
		return menus;
	}

	public void setMenus(List<Menu> menus) {
		this.menus = menus;
	}

	// Mapper 支持开始
	private String useableValue;

	public void setUseableValue(String useableValue) {
		this.useableValue = useableValue;
		setUseable(new Dict(null, useableValue));
	}
    // Mapper 支持结束

}
