package cn.net.wanmo.module.sys.entity;

import java.util.List;

import cn.net.wanmo.base.entity.MyBaseEntity;
import com.google.common.collect.Lists;

import cn.net.wanmo.module.sys.util.DictUtil;
import cn.net.wanmo.module.sys.util.SysDictType;

/**
 * 系统用户 Entity
 */
public class User extends MyBaseEntity<User> {
    private static final long serialVersionUID = 1L;
    public static final String SUPER_USER_ID = "1";

    private String loginName; // 登录名
    private String loginPswd; // 登录密码
    private String hidePswd; // 登录密码
    private String userName; // 用户名
    private Dict userType; // 用户类型
    private Dict gender; // 用户性别
    private String mobileNumber; // 手机号码
    private Dict enable; // 是否禁用

    private List<Role> roles;

    public User() {
        super();
        this.roles = Lists.newArrayList();
    }

    public User(String id) {
        super(id);
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getLoginPswd() {
        return loginPswd;
    }

    public void setLoginPswd(String loginPswd) {
        this.loginPswd = loginPswd;
    }

    public String getHidePswd() {
        return hidePswd;
    }

    public void setHidePswd(String hidePswd) {
        this.hidePswd = hidePswd;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Dict getUserType() {
        userType = DictUtil.fitProperty(userType, SysDictType.USER_TYPE);
        return userType;
    }

    public void setUserType(Dict userType) {
        this.userType = userType;
    }

    public Dict getGender() {
        gender = DictUtil.fitProperty(gender, SysDictType.GENDER);
        return gender;
    }

    public void setGender(Dict gender) {
        this.gender = gender;
    }

    public String getMobileNumber() {
        return mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public Dict getEnable() {
        enable = DictUtil.fitProperty(enable, SysDictType.YES_OR_NO);
        return enable;
    }

    public void setEnable(Dict enable) {
        this.enable = enable;
    }

    public List<Role> getRoles() {
        return roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    @Override
    public String toString() {
        return loginName;
    }

    // Mapper 支持开始
    private String userTypeValue;
    private String genderValue;
    private String enableValue;

    public void setUserTypeValue(String userTypeValue) {
        this.userTypeValue = userTypeValue;
        setUserType(new Dict(null, userTypeValue));
    }

    public void setGenderValue(String genderValue) {
        this.genderValue = genderValue;
        setGender(new Dict(null, genderValue));
    }

    public void setEnableValue(String enableValue) {
        this.enableValue = enableValue;
        setEnable(new Dict(null, enableValue));
    }
// Mapper 支持结束
}
