package cn.net.wanmo.module.sys.enums.dict;

import cn.net.wanmo.module.sys.entity.Dict;

/**
 * 启用和禁用的字典 </br>
 * 启用： y </br>
 * 禁用： n
 */
public enum EnableOrForbid {
    ENABLE("启用", "y"), FORBID("禁用", "n");

    public static final String type = "sys_enable_or_forbid";
    private final String label;
    private final String value;

    EnableOrForbid(String label, String value)
    {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }

    /**
     * 获取当前枚举的字典对象
     */
    public Dict getDict() {
        return new Dict(this.getLabel(), this.getValue(), type);
    }
}
