package cn.net.wanmo.module.sys.service;

import java.util.List;

import cn.net.wanmo.base.service.BaseExtendLayUIService;
import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.entity.Role;

public interface RoleService extends BaseExtendLayUIService<Role> {

	/**
	 * 根据 userId 查询关联的角色集合
	 *
	 * @param userId 用户主键
	 * @return
	 */
	List<Role> findListByUserId(String userId);

	/**
	 * 删除角色与菜单权限关系
	 *
	 * @param roleId 角色主键
	 * @return
	 */
	int deleteRoleMenu(String roleId);

	/**
	 * 插入角色与菜单权限关系
	 *
	 * @param roleId   角色主键
	 * @param menuList 菜单集合
	 * @return
	 */
	int insertRoleMenu(String roleId, List<Menu> menuList);
}
