package cn.net.wanmo.module.sys.service.impl;

import java.util.List;

import cn.net.wanmo.base.service.impl.BaseExtendLayUIServiceImpl;
import org.springframework.stereotype.Service;

import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.module.sys.dao.DictDao;
import cn.net.wanmo.module.sys.entity.Dict;
import cn.net.wanmo.module.sys.service.DictService;
import cn.net.wanmo.module.sys.util.DictUtil;
import cn.net.wanmo.util.EhCacheUtils;

@Service
public class DictServiceImpl extends BaseExtendLayUIServiceImpl<Dict, DictDao> implements DictService {

	@Override
	public List<String> findListType() {
		return dao.findListType();
	}

	@Override
	public List<Dict> findListByType(String type) {
		Dict dict = new Dict();
		dict.setType(type);
		return findList(dict);
	}

	@Override
	public Dict getByTypeValue(String type, String value) {
		Dict dict = new Dict();
		dict.setType(type);
		dict.setValue(value);

		List<Dict> list = findList(dict);
		if (CollectionUtil.isEmpty(list)) {
			return null;
		}

		if (list.size() > 1) {
			throw new RuntimeException(
					String.format("通过 type=%s , value = %s 期望得到1个，实际得到 %d 个 ", type, value, list.size()));
		}

		return list.get(0);
	}

	@Override
	public void clearCache() {
		EhCacheUtils.remove(DictUtil.CACHE_NAME, DictUtil.CACHE_KEY);
	}

}
