package cn.net.wanmo.module.sys.service.impl;

import java.util.List;

import cn.net.wanmo.base.service.impl.BaseExtendLayUIServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.dao.RoleDao;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.service.RoleService;

@Service
public class RoleServiceImpl extends BaseExtendLayUIServiceImpl<Role, RoleDao> implements RoleService {

	@Override
	public List<Role> findListByUserId(String userId) {
		return dao.findListByUserId(userId);
	}

	@Override
	@Transactional(readOnly = false)
	public int deleteRoleMenu(String roleId) {
		if (StringUtil.isBlank(roleId)) {
			return 0;
		}

		return dao.deleteRoleMenu(roleId);
	}

	@Override
	@Transactional(readOnly = false)
	public int insertRoleMenu(String roleId, List<Menu> menuList) {
		if (StringUtil.isBlank(roleId) || CollectionUtil.isEmpty(menuList)) {
			return 0;
		}

		return dao.insertRoleMenu(roleId, menuList);
	}

	/**
	 * 重写保存方法， 同时更新关联的菜单关系
	 */
	@Override
	public int save(Role entity) {
		int num = super.save(entity);

		deleteRoleMenu(entity.getId());
		insertRoleMenu(entity.getId(), entity.getMenus());

		return num;
	}

	/**
	 * 重写删除方法，同时删除关联的菜单关系
	 */
	@Override
	public int delete(String id) {
		deleteRoleMenu(id);

		return super.delete(id);
	}
}
