package cn.net.wanmo.module.sys.service.impl;

import java.util.List;

import cn.net.wanmo.base.service.impl.BaseExtendLayUIServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.dao.UserDao;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.UserService;

@Service
public class UserServiceImpl extends BaseExtendLayUIServiceImpl<User, UserDao> implements UserService {

	@Override
	public User getByLoginName(String loginName) {
		return dao.getByLoginName(loginName);
	}

	@Override
	@Transactional(readOnly = false)
	public int deleteUserRole(String userId) {
		if (StringUtil.isBlank(userId)) {
			return 0;
		}

		return dao.deleteUserRole(userId);
	}

	@Override
	@Transactional(readOnly = false)
	public int insertUserRole(String userId, List<Role> roleList) {
		if (StringUtil.isBlank(userId) || CollectionUtil.isEmpty(roleList)) {
			return 0;
		}

		return dao.insertUserRole(userId, roleList);
	}

	/**
	 * 重写保存方法， 同时更新关联的角色关系
	 */
	@Override
	public int save(User entity) {
		int num = super.save(entity);

		deleteUserRole(entity.getId());
		insertUserRole(entity.getId(), entity.getRoles());

		return num;
	}

	/**
	 * 重新刪除方法，同时删除关联的角色关系
	 */
	@Override
	public int delete(String id) {
		deleteUserRole(id);

		return super.delete(id);
	}

}
