package cn.net.wanmo.module.sys.util;

import java.util.ArrayList;
import java.util.List;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.module.sys.entity.Dict;
import cn.net.wanmo.module.sys.service.DictService;
import cn.net.wanmo.util.EhCacheUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 字典工具类
 */
public class DictUtil {
	private static final Logger logger = LoggerFactory.getLogger(DictUtil.class);
	private static DictService dictService = SpringUtil.getBean(DictService.class);
	public static final String CACHE_NAME = "dictCache";
	public static final String CACHE_KEY = "cacheSysDictAll";

	/**
	 * 根据类型和值 返回字典
	 *
	 * @param type
	 * @param value
	 * @return
	 */
	public static Dict getDict(String type, String value) {
		return getDict(type, value, true);
	}

	/**
	 * 根据类型和值 返回字典
	 *
	 * @param type
	 * @param value
	 * @return
	 */
	public static Dict getDict(String type, String value, boolean isCache) {
		Dict dict = new Dict("", value, type);

		List<Dict> listByType = null;
		if (isCache) {
			listByType = findListByType(type);
		} else {
			listByType = dictService.findListByType(type);
		}

		for (Dict e : listByType) {
			if (StringUtil.equals(value, e.getValue())) {
				dict = e;
				break;
			}
		}

		return dict;
	}

	/**
	 * 根据类型返回字典信息
	 *
	 * @param type
	 * @return
	 */
	public static List<Dict> findListByType(String type) {
		List<Dict> list = new ArrayList<Dict>();

		for (Dict e : findListAll()) {
			if (StringUtil.equals(type, e.getType())) {
				list.add(e);
			}
		}

		return list;
	}

	/**
	 * 查找所有字典信息
	 *
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static List<Dict> findListAll() {
		List<Dict> listDict = null;
		Object object = EhCacheUtils.get(CACHE_NAME, CACHE_KEY);
		if (object == null) {
			listDict = dictService.findList();
			EhCacheUtils.put(CACHE_NAME, CACHE_KEY, listDict);
		} else {
			listDict = (List<Dict>) object;
		}

		return listDict;
	}

	/**
	 * 适配 java 类中的字典属性值
	 *
	 * @param property 属性
	 * @param dictType 字典类型
	 */
	public static Dict fitProperty(Dict property, String dictType) {
		if (property == null || StringUtil.isBlank(property.getValue())) {
			property = new Dict();
			property.setType(dictType);
		} else {
			Dict temp = DictUtil.getDict(dictType, property.getValue());
			property.setLabel(temp.getLabel());
			property.setType(dictType);
		}
		return property;
	}

}
