package cn.net.wanmo.module.sys.util;

import java.util.Iterator;
import java.util.List;

import cn.net.wanmo.plugin.spring.util.SpringUtil;
import com.google.common.collect.Lists;

import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.CollectionUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.module.sys.service.RoleService;
import cn.net.wanmo.module.sys.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 角色 工具类
 */
public class RoleUtil {
	private static final Logger logger = LoggerFactory.getLogger(RoleUtil.class);
	private static RoleService roleService = SpringUtil.getBean(RoleService.class);

	/**
	 * 获取用户拥有的所有可用角色, 如果是超级用户，则拥有所有角色<br>
	 * 将过滤掉未启用的角色
	 *
	 * @return
	 */
	public static List<Role> findListByUser(String userId) {
		return findListByUser(new User(userId));
	}

	/**
	 * 获取用户拥有的所有可用角色, 如果是超级用户，则拥有所有角色<br>
	 * 将过滤掉未启用的角色
	 *
	 * @return
	 */
	public static List<Role> findListByUser(User user) {
		List<Role> returnList = Lists.newArrayList();

		if (user == null || StringUtil.isBlank(user.getId())) {
			return returnList;
		}

		if (StringUtil.equals(User.SUPER_USER_ID, user.getId())) { // 如果是超级用户，则拥有所有角色
			returnList = roleService.findList();
		} else { // 根据 userId 查询关联的角色
			returnList = roleService.findListByUserId(user.getId());
		}

		// 过滤掉未启用的角色
		if (CollectionUtil.isNotEmpty(returnList)) {
			Iterator<Role> it = returnList.iterator();
			while (it.hasNext()) {
				Role role = it.next();
				if (BooleanUtil.toBoolean(role.getUseable().getValue())) {
					continue;
				} else {
					it.remove();
				}
			}
		}

		return returnList;
	}

	/**
	 * 角色列表中是否包含该角色
	 *
	 * @param roleList 角色列表
	 * @param role     判断是否包含的角色
	 * @return 包含 true, 不包含 false
	 */
	public static Boolean isContainRole(List<Role> roleList, Role role) {
		boolean flag = false;

		if (CollectionUtil.isEmpty(roleList) || role == null) {
			flag = false;
		} else {
			for (Role e : roleList) {
				if (StringUtil.equals(e.getId(), role.getId())) {
					flag = true;
					break;
				}

			}
		}

		return flag;
	}
}
