package cn.net.wanmo.module.sys.util;

import cn.net.wanmo.plugin.spring.util.SpringUtil;
import cn.net.wanmo.security.Principal;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 系统用户工具类
 */
public class UserUtil {
    private static final Logger logger = LoggerFactory.getLogger(UserUtil.class);
    private static UserService userService = SpringUtil.getBean(UserService.class);

    /**
     * 获取用户信息
     */
    public static User getUser(String id) {
        if (StringUtil.isBlank(id)) {
            return null;
        }

        return userService.get(id);
    }

    /**
     * 获取授权主体对象
     */
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    /**
     * 获取当前登录者对象
     */
    public static Principal getPrincipal() {
        Principal principal = null;
        try {
            Subject subject = getSubject();
            principal = (Principal) subject.getPrincipal();
        } catch (Exception e) {
            principal = null;
        }
        return principal;
    }

    /**
     * 获取 Shiro Session
     */
    public static Session getSession() {
        Session session = null;
        try {
            Subject subject = getSubject();
            session = subject.getSession();
        } catch (InvalidSessionException e) {
            session = null;
        }
        return session;
    }

    /**
     * 获取当前登录者对象
     */
    public static User getLoginUser() {
        Principal principal = getPrincipal();
        if (principal == null) {
            return null;
        }
        return getUser(principal.getId());
    }

}
