package cn.net.wanmo.timertask;

import cn.net.wanmo.module.sys.util.DictUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/**
 * TimerTask 定时任务工具类
 */
public class TimerTaskDict {

	/** 管理所有启用的定时任务 */
	private static List<Timer> listTimer = new ArrayList<Timer>();

	/**
	 * 启动定时任务
	 */
	public static void startTask() {
		startDictCacheTask();
	}

	/**
	 * 字典缓存任务<br>
	 * 5 秒钟后执行， 每隔6个小时更新一次
	 */
	public static void startDictCacheTask() {
		Timer timer = new Timer("dict_cache_task");
		timer.schedule(new TimerTask() {
			@Override
			public void run() {
				DictUtil.findListAll();
			}
		}, 5 * 1000, 1000 * 60 * 60 * 6);

		listTimer.add(timer);
	}


	/**
	 * 取消定时任务
	 */
	public static void closeTask() {
		try {
			if (listTimer == null || listTimer.isEmpty()) {
				return;
			}

			for (Timer timer : listTimer) {
				timer.toString();
				timer.cancel();
				timer.purge();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
