package cn.net.wanmo.base.entity;

import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.module.sys.entity.User;
import cn.net.wanmo.module.sys.util.UserUtil;
import cn.net.wanmo.security.Principal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value = { "hibernateLazyInitializer", "handler" })
public abstract class MyBaseEntity<Entity> extends BaseEntity<Entity> {
	private static final long serialVersionUID = -4504153476364215436L;
	/** 创建用户 */
	protected User createUser;
	/** 修改用户 */
	protected User updateUser;

	public MyBaseEntity() {
	}

	public MyBaseEntity(String id) {
		super(id);
	}

	@JsonIgnore
	public User getCreateUser() {
		final String createUserId = getCreateUserId();
		if (StringUtil.isBlank(createUserId)) {
			return createUser;
		}

		return new User(createUserId);
	}

	public void setCreateUser(User createUser) {
		this.createUser = createUser;
	}

	@JsonIgnore
	public User getUpdateUser() {
		final String updateUserId = getUpdateUserId();
		if (StringUtil.isBlank(updateUserId)) {
			return updateUser;
		}

		return new User(updateUserId);
	}

	public void setUpdateUser(User updateUser) {
		this.updateUser = updateUser;
	}

	@Override
	public void preInsert() {
		super.preInsert();

		setCreateUser(new User(getCurrentUserId()));
		setUpdateUser(new User(getCurrentUserId()));
	}

	@Override
	public void preUpdate() {
		super.preUpdate();

		setUpdateUser(new User(getCurrentUserId()));
	}

	@Override
	public String getCurrentUserId() {
		Principal principal = UserUtil.getPrincipal();
		if (principal == null) {
			return null;
		}
		return principal.getId();
	}

	@Override
	public void setCreateUserId(String createUserId) {
		super.setCreateUserId(createUserId);
		setCreateUser(new User(createUserId));
	}

	@Override
	public void setUpdateUserId(String updateUserId) {
		super.setUpdateUserId(updateUserId);
		setUpdateUser(new User(updateUserId));
	}
}
