package cn.net.wanmo.module.sys.dao;

import java.util.List;

import cn.net.wanmo.base.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import cn.net.wanmo.module.sys.entity.Menu;
import cn.net.wanmo.module.sys.entity.Role;
import cn.net.wanmo.mybatis.annotation.MyBatisDao;

/**
 * 角色 DAO
 */
@MyBatisDao
public interface RoleDao extends BaseDao<Role> {

    /**
     * 根据 userId 查询关联的角色集合
     *
     * @param userId 用户主键
     * @return 角色集合
     */
    List<Role> findListByUserId(String userId);

    /**
     * 删除角色与菜单权限关系
     *
     * @param roleId 角色主键
     * @return 影响行数
     */
    int deleteRoleMenu(@Param("roleId") String roleId);

    /**
     * 插入角色与菜单权限关系
     *
     * @param roleId   角色主键
     * @param menuList 菜单集合
     * @return 影响行数
     */
    int insertRoleMenu(@Param("roleId") String roleId, @Param("menuList") List<Menu> menuList);
}
