package cn.net.wanmo.module.sys.entity;

import cn.net.wanmo.base.entity.MyBaseTreeEntity;

/**
 * 部门 Entity
 */
public class Dept extends MyBaseTreeEntity<Dept> {
    private static final long serialVersionUID = 1L;
    public static final String ROOT_ID = "1";

    private String code; // 部门编号
    private String name; // 部门名称
    private Integer hierarchy; // 层级

    public Dept() {
        super();
    }

    public Dept(String id) {
        super(id);
    }

    public Dept(Dept parent) {
        super();
        this.parent = parent;
    }

    @Override
    public String getParentId() {
        return parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getParentIds() {
        return parentIds;
    }

    @Override
    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getHierarchy() {
        return hierarchy;
    }

    @Override
    public void setHierarchy(Integer hierarchy) {
        this.hierarchy = hierarchy;
    }

    @Override
    public String getDefaultOrderBy() {
        return " a.code ";
    }

    @Override
    public String getRootId() {
        return ROOT_ID;
    }

}
