package cn.net.wanmo.module.sys.entity;


import cn.net.wanmo.base.entity.MyBaseEntity;

/**
 * 字典 Entity
 */
public class Dict extends MyBaseEntity<Dict> {
	private static final long serialVersionUID = -5671264787052587524L;
	private String label; // 字典文本
	private String value; // 字典值
	private String type; // 字典类型
	private Integer sort; // 字典排序
	private String describe; // 字典描述

	public Dict() {
		super();
	}

	public Dict(String id) {
		super(id);
	}

	public Dict(String label, String value) {
		super();
		this.label = label;
		this.value = value;
	}

	public Dict(String label, String value, String type) {
		this();
		this.label = label;
		this.value = value;
		this.type = type;
	}

	public Dict(String label, String value, String type, String describe) {
		this();
		this.label = label;
		this.value = value;
		this.type = type;
		this.describe = describe;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public String getDescribe() {
		return describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	@Override
	public String toString() {
		return "Dict [label=" + label + ", value=" + value + ", type=" + type + ", describe=" + describe + "]";
	}

	@Override
	public String getDefaultOrderBy() {
		return " a.dict_type, a.dict_sort ";
	}

}
